/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadTask;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedSerialTask;
import java.util.Collection;
import java.util.Set;
import org.joda.time.Interval;

public abstract class AbstractLoadTradesTask
extends LoadTask {
    protected AbstractLoadTradesTask(ComXervLoadContext loadContext) {
        super(loadContext);
    }

    protected boolean hasPermissionsForTrades() {
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        return userRoles.isTrader() || userRoles.isBroker() || userRoles.isSalesUser() || userRoles.isAdmin() || userRoles.isDataVendor();
    }

    protected static class LoadTradesSlicedTask
    extends SlicedSerialTask<Interval> {
        private final ComXervLoadContext context;

        public LoadTradesSlicedTask(Collection<Interval> sliceInputs, ComXervLoadContext context) {
            super("Load Trades task", sliceInputs);
            this.context = context;
        }

        @Override
        protected void loadData(Interval sliceInput) {
            if (this.context.getConnection() != null) {
                Set<FullTrade> trades = this.context.getConnection().getTrades(this.context.getBalancingGroupsFromUser(), sliceInput.getStart(), sliceInput.getEnd());
                this.context.handleEntities(FullTrade.class, trades, false);
            }
        }
    }
}

