/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import java.util.HashSet;
import java.util.Set;

public class LoadCommodityTradingLimitsTask
extends LoadSingleEntityTypeTask<TradingLimit> {
    public LoadCommodityTradingLimitsTask(ComXervLoadContext loadContext) {
        super(loadContext, TradingLimit.class);
    }

    @Override
    protected Set<TradingLimit> load() {
        HashSet<TradingLimit> result = new HashSet<TradingLimit>();
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        boolean hasProperRole = userRoles.isAdmin() || userRoles.isTrader() || userRoles.isBroker();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null && hasProperRole && this.getLoadContext().getExchange().getSystemInfo().supportsTradingLimit()) {
            result.addAll(connection.getCommodityLimits());
        }
        return result;
    }

    @Override
    public boolean runCondition() {
        return this.getLoadContext().getExchange().getSystemInfo().supportsTradingLimit();
    }
}

