/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.joda.time.Interval;

public class LoadHubToHubTask
extends LoadSingleEntityTypeTask<HubToHub> {
    private final Executor executor;

    public LoadHubToHubTask(ComXervLoadContext loadContext, Executor executor) {
        super(loadContext, HubToHub.class);
        this.executor = executor;
    }

    @Override
    protected Set<HubToHub> load() {
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        final AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null && userRoles.isCapacityInfo()) {
            final HashSet<HubToHub> result = new HashSet<HubToHub>();
            List<Interval> intervals = this.getLoadContext().getTimeSlicesForHubToHub();
            new SlicedTask<Interval, Set<HubToHub>>(this, "Load HubToHub", this.executor, intervals){

                @Override
                protected Set<HubToHub> runSlowAsyncPart(Interval interval) {
                    return connection.getHubToHub(interval.getStart().toLocalDate());
                }

                @Override
                protected void runFastSyncPart(Set<HubToHub> hubToHubs) {
                    result.addAll(hubToHubs);
                }
            }.run();
            return result;
        }
        return Collections.emptySet();
    }
}

