/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.AbstractComXervService;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeoutFactory;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.user.ChangePasswordService;
import com.deutscheboerse.comxerv.comtrader.service.user.TotpResponseHandler;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.ChgPwdReq;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import com.deutscheboerse.m7.trading.api.v6.TotpPwdReq;
import com.deutscheboerse.m7.trading.api.v6.TotpPwdResp;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ChangePasswordServiceImpl
extends AbstractComXervService
implements ChangePasswordService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordServiceImpl.class);
    private final ExecutorService executorService;
    private final ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory;
    private final MessagePublisher messagePublisher;

    @Inject
    public ChangePasswordServiceImpl(ApplicationContext appContext) {
        super(appContext);
        this.responseHandlerWithTimeoutFactory = appContext.getService(ResponseHandlerWithTimeoutFactory.class);
        this.executorService = appContext.getService(ExecutorService.class, SenderExecutor.class);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
    }

    @Override
    public boolean changePasswordPossible() {
        return this.getSession() != null;
    }

    @Override
    public void changePassword(String oldPwd, String newPwd, String newPwdConf, ResponseHandler responseHandler) {
        ResponseHandler messagePublishingResponseHandler = responseHandler.chain(this.messagePublisher::publishMessage);
        if (StringUtils.isEmpty(newPwd)) {
            messagePublishingResponseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("changeMaster_wrongEmpty"), null));
        } else if (Objects.equals(oldPwd, newPwd)) {
            messagePublishingResponseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("commons_sameNewAndOld"), null));
        } else if (!Objects.equals(newPwd, newPwdConf)) {
            messagePublishingResponseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("changeMaster_wrongNoMatch"), null));
        } else {
            this.doChangePassword(oldPwd, newPwd, messagePublishingResponseHandler);
        }
    }

    private void doChangePassword(String oldPwd, String newPwd, ResponseHandler responseHandler) {
        ComXervExchangeConnection exchangeConnection = (ComXervExchangeConnection)this.getConnection();
        this.executorService.submit(() -> {
            try {
                LOG.info("Creating change password request");
                ChgPwdReq request = this.createChangePasswordRequest(exchangeConnection, oldPwd, newPwd);
                this.sendRequestWithTimeout(exchangeConnection, responseHandler, request);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating change password request", e);
                responseHandler.handleGeneralError();
            }
        });
    }

    private ChgPwdReq createChangePasswordRequest(ComXervExchangeConnection connection, String currentPwd, String newPwd) {
        StandardHeaderType standardHeader = connection.createStandardHeader();
        ChgPwdReq request = new ChgPwdReq();
        request.setStandardHeader(standardHeader);
        request.setCurrentPwd(currentPwd);
        request.setNewPwd(newPwd);
        return request;
    }

    private void sendRequestWithTimeout(ExchangeConnection connection, ResponseHandler responseHandler, Request request) {
        String correlationId = CorrelationId.next();
        ResponseHandlerWithTimeout responseHandlerWithTimeout = this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId);
        ObjectHandler<Object> objectHandler = this.getObjectHandler(correlationId, responseHandlerWithTimeout);
        connection.addObjectHandler(objectHandler);
        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
        ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
        this.processServerResponse(response, responseHandlerWithTimeout, connection, objectHandler);
    }

    private void processServerResponse(ResponseWithCorrelationId responseWithCorrelationId, ResponseHandler responseHandler, ExchangeConnection connection, ObjectHandler<Object> objectHandler) {
        boolean expectOtherMessages;
        if (responseWithCorrelationId.getResponse() != null && !(expectOtherMessages = this.processImmediateServerResponse(responseWithCorrelationId.getResponse(), responseHandler))) {
            connection.removeObjectHandler(objectHandler);
        }
    }

    private ObjectHandler<Object> getObjectHandler(String expectedCorrelationId, @Nonnull ResponseHandler responseHandler) {
        return (session, broadcastObject, correlationId) -> {
            if (expectedCorrelationId.equals(correlationId) && this.processAsyncServerResponseForPasswordChange(broadcastObject, responseHandler)) {
                return ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    private boolean processAsyncServerResponseForPasswordChange(Object response, @Nonnull ResponseHandler responseHandler) {
        if (response instanceof ErrResp) {
            ErrResp errResp = (ErrResp)response;
            this.handleErrors(errResp.getError().stream(), responseHandler);
            return true;
        }
        return false;
    }

    @Override
    public void configureTotpPassword(String currentPwd, TotpResponseHandler totpResponseHandler) {
        this.executorService.submit(() -> {
            try {
                LOG.info("Creating TOTP password request");
                TotpPwdReq request = this.createTotpPwdRequest(currentPwd);
                this.sendTotpRequest(totpResponseHandler, request);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating TOTP password request", e);
                totpResponseHandler.getErrorHandler().handleGeneralError();
            }
        });
    }

    private TotpPwdReq createTotpPwdRequest(String currentPwd) {
        TotpPwdReq request = new TotpPwdReq();
        request.setStandardHeader(this.getStandardHeader(false));
        request.setCurrentPwd(currentPwd);
        return request;
    }

    private void sendTotpRequest(TotpResponseHandler totpResponseHandler, Request request) {
        ResponseWithCorrelationId responseWithCorrelationId = this.getConnection().sendRequest(request, false, CorrelationId.next());
        if (responseWithCorrelationId.getResponse() != null) {
            Object response = responseWithCorrelationId.getResponse();
            if (response instanceof ErrResp) {
                ErrResp errResp = (ErrResp)response;
                this.handleErrors(errResp.getError().stream(), totpResponseHandler.getErrorHandler());
            } else if (response instanceof Exception) {
                Exception exception = (Exception)response;
                totpResponseHandler.getErrorHandler().handleGeneralError(exception.getMessage());
            } else if (response instanceof TotpPwdResp) {
                TotpPwdResp totpPwdResp = (TotpPwdResp)response;
                totpResponseHandler.handleResponse(totpPwdResp.getSecret());
            } else {
                LOG.error("Unknown server response: {}", response);
            }
        } else {
            LOG.error("No server response: {}", (Object)responseWithCorrelationId);
        }
    }
}

