/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.RequestClassifier;
import com.deutscheboerse.m7.trading.api.v6.AckResp;
import com.deutscheboerse.m7.trading.api.v6.OrdrEntry;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRprt;
import com.deutscheboerse.m7.trading.api.v6.OrdrModType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModify;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksDeltaRprt;

@ExchangeSpecific(apiVersion="v6")
public class ComXervRequestClassifier
implements RequestClassifier {
    @Override
    public RequestClassifier.ResponseType getResponseType(Object object) {
        if (object instanceof AckResp) {
            return RequestClassifier.ResponseType.ACK;
        }
        if (object instanceof OrdrExeRprt) {
            return RequestClassifier.ResponseType.EXECUTION;
        }
        if (object instanceof PblcOrdrBooksDeltaRprt) {
            return RequestClassifier.ResponseType.ORDERBOOK;
        }
        return RequestClassifier.ResponseType.OTHER;
    }

    @Override
    public String getOperationType(Object request) {
        if (request instanceof OrdrEntry) {
            return "ENTRY";
        }
        if (request instanceof OrdrModify) {
            OrdrModType ordrModType = ((OrdrModify)request).getOrdrModType();
            switch (ordrModType) {
                case ACTI: {
                    return "ACTIVATE";
                }
                case DEAC: {
                    return "DEACTIVATE";
                }
                case MODI: {
                    return "MODIFY";
                }
                case DELE: {
                    return "CANCEL";
                }
            }
        }
        return "OTHER";
    }
}

