/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EntityNotFoundException;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.TradeInfo;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.m7.trading.api.v6.HalfTradeType;
import com.deutscheboerse.m7.trading.api.v6.TradeListEntryType;
import java.util.Optional;

public class HalfTradeMapper {
    private static final String SYSTEM_USERID = "SYSTEM";
    private final DataModel<Integer, User> userDataModel;
    private final UserQueries userQueries;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;

    public HalfTradeMapper(ApplicationContext context) {
        this.userDataModel = context.getSmallDataModel(User.class);
        this.userQueries = context.getService(UserQueries.class);
        this.deliveryAreaDataModel = context.getDataModel(DeliveryArea.class);
        this.balancingGroupDataModel = context.getSmallDataModel(BalancingGroup.class);
    }

    public HalfTrade createHalfTrade(TradeListEntryType from, TradeInfo tradeInfo, Direction direction) {
        HalfTrade halfTrade = new HalfTrade(from.getTradeId(), direction, tradeInfo);
        halfTrade.setOrder(this.mapHalfTradeToOrder(from, direction));
        halfTrade.setRevisionNumber(from.getRevisionNo());
        return halfTrade;
    }

    private Trade.OrderInfo mapHalfTradeToOrder(TradeListEntryType from, Direction direction) {
        HalfTradeType halfTrade = this.getHalfTradeType(from, direction);
        if (SYSTEM_USERID.equals(halfTrade.getUsrCode())) {
            return new Trade.OrderInfo(halfTrade.getOrdrId(), direction, null, null, halfTrade.getMbrId(), halfTrade.getUsrCode(), null, halfTrade.getDlvryAreaId(), this.findDeliveryArea(halfTrade), halfTrade.getAcctId(), null, halfTrade.getClearingAcctType(), halfTrade.getTxt(), EnumMapper.mapOpenCloseIndType(halfTrade.getOpenCloseInd()), halfTrade.getClOrdrId(), EnumMapper.mapAggressorIndicatorType(halfTrade.getAggressorIndicator()));
        }
        User user = this.findUser(halfTrade);
        Integer brokerUserId = null;
        User brokerUser = null;
        if (user.getRoles().isBroker() || user.getRoles().isAdmin()) {
            brokerUserId = halfTrade.getBrokerUserId();
            brokerUser = this.findBrokerUser(halfTrade);
        }
        return new Trade.OrderInfo(halfTrade.getOrdrId(), direction, brokerUserId, brokerUser, halfTrade.getMbrId(), halfTrade.getUsrCode(), user, halfTrade.getDlvryAreaId(), this.findDeliveryArea(halfTrade), halfTrade.getAcctId(), this.findBalancingGroup(halfTrade), halfTrade.getClearingAcctType(), halfTrade.getTxt(), EnumMapper.mapOpenCloseIndType(halfTrade.getOpenCloseInd()), halfTrade.getClOrdrId(), EnumMapper.mapAggressorIndicatorType(halfTrade.getAggressorIndicator()));
    }

    private HalfTradeType getHalfTradeType(TradeListEntryType from, Direction direction) {
        return switch (direction) {
            case Direction.BUY -> from.getBuy();
            case Direction.SELL -> from.getSell();
            default -> throw new IllegalStateException("no direction given");
        };
    }

    private BalancingGroup findBalancingGroup(HalfTradeType halfTrade) {
        String bgId = halfTrade.getAcctId();
        BalancingGroup bg = this.balancingGroupDataModel.findById(bgId);
        if (bg == null) {
            throw new EntityNotFoundException("Balancing group %s not found. It was referenced from the half-trade %s", bgId, halfTrade);
        }
        return bg;
    }

    private DeliveryArea findDeliveryArea(HalfTradeType halfTrade) {
        String daId = halfTrade.getDlvryAreaId();
        DeliveryArea da = this.deliveryAreaDataModel.findById(daId);
        if (da == null) {
            throw new EntityNotFoundException("Delivery Area %s not found. It was referenced from the half-trade %s", daId, halfTrade);
        }
        return da;
    }

    private User findUser(HalfTradeType halfTrade) {
        String mbrId = halfTrade.getMbrId();
        String usrCode = halfTrade.getUsrCode();
        Optional<User> user = this.userQueries.findByMemberIdAndCode(mbrId, usrCode).getFirst();
        return user.orElseThrow(() -> new EntityNotFoundException("User %s/%s not found. It was referenced from the half-trade %s", mbrId, usrCode, halfTrade));
    }

    private User findBrokerUser(HalfTradeType halfTrade) {
        if (halfTrade.getBrokerUserId() == null) {
            return null;
        }
        User user = this.userDataModel.findById(halfTrade.getBrokerUserId());
        if (user == null) {
            throw new EntityNotFoundException("Broker User %d not found. It was referenced from the half-trade %s", halfTrade.getBrokerUserId(), halfTrade);
        }
        return user;
    }
}

