/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AbstractTextWithVarsMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageType;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.type.StatusMessageType;
import com.deutscheboerse.m7.trading.api.v6.MsgListEntryType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMapper
extends AbstractTextWithVarsMapper<MsgListEntryType, Message> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageMapper.class);
    private final TimeService timeService;

    public MessageMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, MsgListEntryType.class, Message.class);
        this.timeService = applicationContext.getService(TimeService.class);
    }

    @Override
    public Message translate(MsgListEntryType from, MapperHandler mapperHandler, Object hint) {
        String messageText;
        MessageType type = this.mapMessageType(from);
        MessageSeverity severity = this.mapMessageSeverity(from);
        SpecialMessage specialMessage = this.mapSpecialMessage(from.getMessageCode());
        DateTime timestamp = DateTimeUtils.mapDateToDateTime(from.getTimestmp(), this.getExchange().getSystemInfo().getTimeZone());
        if (timestamp == null) {
            LOG.warn("A message with an empty timestamp arrived from the server. {}", (Object)from);
            timestamp = this.timeService.getServerTime();
        }
        try {
            messageText = this.getMessageFormatter().formatMessage(from.getMessageCode(), this.mapVars(from.getVarList()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown message code: {}, using untranslated text as fallback.", (Object)from.getMessageCode());
            messageText = from.getTxt();
        }
        if (from.getMessageCode() == StatusMessageType.MSG_TEXT_ADMIN.getMessageCode() || from.getMessageCode() == StatusMessageType.MSG_SOB_CAPACITY_RECALL_NOT_POSSIBLE_PRIVATE.getMessageCode() || from.getMessageCode() == StatusMessageType.MSG_SOB_CAPACITY_RECALL_NOT_POSSIBLE_PUBLIC.getMessageCode()) {
            messageText = from.getTxt();
        }
        return Message.createServerMessage(this.getExchange(), from.getMsgId(), timestamp, messageText, severity, type, from.isMktSupervisionMsg(), specialMessage);
    }

    private MessageType mapMessageType(MsgListEntryType from) {
        switch (from.getType()) {
            case PUBLIC: {
                return MessageType.PUBLIC;
            }
            case PRIVATE: {
                return MessageType.PRIVATE;
            }
        }
        throw new IllegalStateException(from.getType().toString());
    }

    private SpecialMessage mapSpecialMessage(int messageCode) {
        if (messageCode == StatusMessageType.MSG_TRADE_RECALL_ACCEPTED.getMessageCode()) {
            return SpecialMessage.TRADE_RECALL_ACCEPTED;
        }
        if (messageCode == StatusMessageType.MSG_ADMIN_RECALL_TRADE.getMessageCode()) {
            return SpecialMessage.TRADE_RECALL_REQUESTED;
        }
        if (messageCode == StatusMessageType.MSG_ADMIN_RECALL_TRADE_ONBEHALF.getMessageCode()) {
            return SpecialMessage.TRADE_RECALL_REQUESTED_ON_BEHALF;
        }
        if (messageCode == StatusMessageType.MSG_TRADE_CANCELLED_PRIVATE_TRADER.getMessageCode()) {
            return SpecialMessage.TRADE_CANCELLED;
        }
        if (messageCode == StatusMessageType.MSG_TRADE_CANCELLED_PRIVATE_ADMIN.getMessageCode()) {
            return SpecialMessage.TRADE_CANCELLED;
        }
        if (messageCode == StatusMessageType.MSG_SOB_CAPACITY_RECALL_NOT_POSSIBLE_PRIVATE.getMessageCode()) {
            return SpecialMessage.TRADE_RECALL_REJECTED_NO_CAPACITY;
        }
        return null;
    }

    private MessageSeverity mapMessageSeverity(MsgListEntryType from) {
        switch (from.getSvrty()) {
            case ERR: {
                return MessageSeverity.ERROR;
            }
            case HIG: {
                return MessageSeverity.HIGH;
            }
            case LOW: {
                return MessageSeverity.LOW;
            }
            case MED: {
                return MessageSeverity.MEDIUM;
            }
            case URG: {
                return MessageSeverity.URGENT;
            }
        }
        throw new IllegalStateException(from.getSvrty().toString());
    }
}

