/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.OrdrBookEntryType;
import com.deutscheboerse.m7.trading.api.v6.OrdrBookType;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksDeltaRprt;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderbookMapper
extends AbstractMapper<OrdrBookType, Orderbook> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderbookMapper.class);
    private final DataModel<Long, Contract> contractDataModel;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;
    private final DataModel<Long, Order> orderDataModel;
    private final TimeService timeService;
    private final OwnQuantityLookupService ownQuantityLookupService;
    private final ComXervExchangeConnection connection;

    public OrderbookMapper(ApplicationContext applicationContext, Exchange exchange, ComXervExchangeConnection connection) {
        super(applicationContext, exchange, OrdrBookType.class, Orderbook.class);
        this.connection = connection;
        this.contractDataModel = applicationContext.getDataModel(Contract.class);
        this.deliveryAreaDataModel = applicationContext.getDataModel(DeliveryArea.class);
        this.orderDataModel = applicationContext.getDataModel(Order.class);
        this.timeService = applicationContext.getService(TimeService.class);
        this.ownQuantityLookupService = applicationContext.getService(OwnQuantityLookupService.class);
    }

    @Override
    public Orderbook translate(OrdrBookType from, MapperHandler mapperHandler, Object hint) {
        Contract contract = this.contractDataModel.findById(from.getContractId());
        if (contract == null) {
            LOG.warn("Contract not found: {}", (Object)from.getContractId());
            if (hint == PblcOrdrBooksDeltaRprt.class && !from.getOtherAttributes().containsKey(OBJECT_RETRY_KEY)) {
                from.getOtherAttributes().put(OBJECT_RETRY_KEY, null);
                PblcOrdrBooksDeltaRprt pblcOrdrBooksDeltaRprt = new PblcOrdrBooksDeltaRprt();
                pblcOrdrBooksDeltaRprt.setOrdrbookList(new PblcOrdrBooksDeltaRprt.OrdrbookList());
                pblcOrdrBooksDeltaRprt.getOrdrbookList().getOrdrBook().add(from);
                this.connection.getObjectRouter().addRetryObject(pblcOrdrBooksDeltaRprt, null);
            }
            return null;
        }
        String deliveryAreaId = from.getDlvryAreaId();
        DeliveryArea deliveryArea = this.deliveryAreaDataModel.findById(deliveryAreaId);
        if (deliveryArea == null) {
            LOG.warn("Delivery area not found: {}", (Object)deliveryAreaId);
            return null;
        }
        Orderbook orderbook = new Orderbook(contract, deliveryArea, this.ownQuantityLookupService);
        this.setOrderbookAttributes(from, orderbook, contract, deliveryAreaId);
        return orderbook;
    }

    private void mapSurplusQuantity(OrdrBookType from, Orderbook orderbook) {
        Product product = orderbook.getContract().getProduct();
        Integer surplusBid = from.getSurplusBid();
        Integer surplusAsk = from.getSurplusAsk();
        if (surplusBid != null && surplusBid > 0) {
            orderbook.setAuctionSurplus(product.mapQuantityFromBackend(surplusBid));
        } else if (surplusAsk != null && surplusAsk > 0) {
            orderbook.setAuctionSurplus(product.mapQuantityFromBackend(-1 * surplusAsk));
        } else {
            orderbook.setAuctionSurplus(null);
        }
    }

    private void addOrderbookEntries(Orderbook orderbook, List<OrdrBookEntryType> entries2, Set<OrderbookEntry> orderbookEntries, long localTimestamp) {
        for (OrdrBookEntryType ordBkEntryType : entries2) {
            OrderbookEntry orderbookEntry = this.createOrderbookEntry(orderbook, ordBkEntryType, localTimestamp);
            orderbookEntries.add(orderbookEntry);
        }
    }

    private OrderbookEntry createOrderbookEntry(Orderbook orderbook, OrdrBookEntryType ordBkEntryType, long localTimestamp) {
        Product product = orderbook.getContract().getProduct();
        DateTime time = DateTimeUtils.mapDateToDateTime(ordBkEntryType.getOrdrEntryTime(), this.getExchange().getSystemInfo().getTimeZone());
        Optional<Order> order = Optional.ofNullable(this.orderDataModel.findById(ordBkEntryType.getOrdrId()));
        LongDisplayValue quantity = product.mapQuantityFromBackend(ordBkEntryType.getQty());
        LongDisplayValue remainingQuantity = order.map(Order::getRemainingQuantity).orElse(quantity);
        OrderType orderType = order.map(Order::getOrderType).orElse(this.mapOrderType(ordBkEntryType.getOrdrType()));
        return OrderbookEntry.newBuilder().withOrderId(ordBkEntryType.getOrdrId()).withPrice(product.mapPriceFromBackend(ordBkEntryType.getPx())).withQuantity(quantity).withTime(time).withOrderType(orderType).withExecutionRestriction(ordBkEntryType.getOrdrExeRestriction() != null ? EnumMapper.mapOrdrExeRestrictionType(ordBkEntryType.getOrdrExeRestriction()) : ExecutionRestriction.NONE).withRemainingQuantity(remainingQuantity).withLocalTimestamp(localTimestamp).build();
    }

    private OrderType mapOrderType(OrdrType ordrType) {
        if (ordrType != null) {
            switch (ordrType) {
                case O: {
                    return OrderType.REGULAR;
                }
                case I: {
                    return OrderType.ICEBERG;
                }
                case L: {
                    return OrderType.BALANCE;
                }
            }
        }
        return null;
    }

    private ValueChange mapPriceChange(int value) {
        switch (value) {
            case 0: {
                return ValueChange.SAME;
            }
            case -1: {
                return ValueChange.DOWN;
            }
            case 1: {
                return ValueChange.UP;
            }
        }
        throw new IllegalArgumentException();
    }

    private void setOrderbookAttributes(OrdrBookType from, Orderbook orderbook, Contract contract, String deliveryAreaId) {
        long localTimestamp = this.timeService.getLocalTime().getMillis();
        orderbook.setId(deliveryAreaId + "|" + from.getContractId());
        Product product = contract.getProduct();
        if (from.getLastTradeTime() != null) {
            orderbook.setLastTradeTime(DateTimeUtils.mapDateToDateTime(from.getLastTradeTime(), this.getExchange().getSystemInfo().getTimeZone()));
        }
        if (from.getLastPx() != null) {
            orderbook.setLastPrice(product.mapPriceFromBackend(from.getLastPx()));
            if (from.getPxDir() != null) {
                orderbook.setPriceChange(this.mapPriceChange(from.getPxDir()));
            }
        }
        if (from.getLastQty() != null) {
            orderbook.setLastQuantity(product.mapQuantityFromBackend(from.getLastQty()));
        }
        if (from.getHighPx() != null) {
            orderbook.setHi(product.mapPriceFromBackend(from.getHighPx()));
        }
        if (from.getLowPx() != null) {
            orderbook.setLow(product.mapPriceFromBackend(from.getLowPx()));
        }
        if (from.getTotalQty() != null) {
            orderbook.setTotalTradedQty(product.mapQuantityFromBackend(from.getTotalQty()));
        }
        if (from.getIndicativePx() != null) {
            orderbook.setAuctionIndicativePrice(product.mapPriceFromBackend(from.getIndicativePx()));
        }
        this.mapSurplusQuantity(from, orderbook);
        orderbook.setRevisionNumber(from.getRevisionNo());
        HashSet<OrderbookEntry> buys = new HashSet<OrderbookEntry>();
        if (from.getBuyOrdrList() != null) {
            this.addOrderbookEntries(orderbook, from.getBuyOrdrList().getOrdrBookEntry(), buys, localTimestamp);
        }
        orderbook.setBuys(buys);
        HashSet<OrderbookEntry> sells = new HashSet<OrderbookEntry>();
        if (from.getSellOrdrList() != null) {
            this.addOrderbookEntries(orderbook, from.getSellOrdrList().getOrdrBookEntry(), sells, localTimestamp);
        }
        orderbook.setSells(sells);
    }
}

