/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class MessageDataModel
extends SmallFastDataModelBase<String, Message> {
    private static final String MAX_NUMBER_OF_MESSAGES_APPLICATION_PROPERTY = "maxNumberOfMessages";
    private final TimeService timeService;
    private final ApplicationConfigurationService applicationConfigurationService;
    private Deque<Message> messagesDeque = new ArrayDeque<Message>();

    public MessageDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
        this.timeService = applicationContext.getService(TimeService.class);
        this.applicationConfigurationService = applicationContext.getService(ApplicationConfigurationService.class);
    }

    @Override
    public Class<Message> getEntityClass() {
        return Message.class;
    }

    @Override
    public Message add(Message entity) {
        if (!this.messagesDeque.isEmpty()) {
            this.messagesDeque.addFirst(entity);
        }
        Message addedMessage = super.add(entity);
        if (!this.messagesDeque.isEmpty()) {
            this.remove(this.messagesDeque.removeLast());
        }
        return addedMessage;
    }

    @Override
    public Set<Message> addAll(Collection<Message> entities) {
        ArrayList<Message> messagesToRemove = new ArrayList<Message>();
        HashSet<Message> addedMessages = new HashSet<Message>();
        for (Message message : entities) {
            if (!this.messagesDeque.isEmpty()) {
                this.messagesDeque.addFirst(message);
            }
            addedMessages.add(super.add(message));
            if (this.messagesDeque.isEmpty()) continue;
            messagesToRemove.add(this.messagesDeque.removeLast());
        }
        if (!messagesToRemove.isEmpty()) {
            this.removeAll(messagesToRemove);
        }
        return addedMessages;
    }

    @Override
    public void runCleanup() {
        DateTime currentTime = this.timeService.getLocalTime();
        Set oldMessages = this.entities.values().stream().filter(message -> message.getTimeStamp().isBefore(currentTime.minusDays(1))).collect(Collectors.toSet());
        this.removeAll(oldMessages);
        this.messagesDeque.removeAll(oldMessages);
        this.populateMessagesDeque();
    }

    private void populateMessagesDeque() {
        if (this.entities.size() > this.getMaxNumberOfMessagesAllowed() && this.messagesDeque.isEmpty()) {
            List<Object> messagesList = new ArrayList(this.entities.values());
            Collections.sort(messagesList, Comparator.reverseOrder());
            if (messagesList.size() > this.getMaxNumberOfMessagesAllowed()) {
                this.removeAll(messagesList.subList(this.getMaxNumberOfMessagesAllowed(), messagesList.size()));
                messagesList = messagesList.subList(0, this.getMaxNumberOfMessagesAllowed());
            }
            this.messagesDeque.addAll(messagesList);
        }
    }

    private Integer getMaxNumberOfMessagesAllowed() {
        return this.applicationConfigurationService.getIntegerApplicationProperty(MAX_NUMBER_OF_MESSAGES_APPLICATION_PROPERTY, Integer.MAX_VALUE);
    }
}

