/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Pair;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Utils;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.AbstractDataQuery;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LargeDataModelQuery<I extends Comparable<I>, T extends BroadcastEntity<I>, K2>
extends AbstractDataQuery<T> {
    private final NavigableSet<Pair<K2, I>> index;
    private final Function<I, T> entitySupplier;
    private final K2 key;

    public LargeDataModelQuery(Function<I, T> entitySupplier, NavigableSet<Pair<K2, I>> index, K2 key) {
        this(entitySupplier, index, key, t -> true);
    }

    private LargeDataModelQuery(Function<I, T> entitySupplier, NavigableSet<Pair<K2, I>> index, K2 key, Predicate<T> filter) {
        super(filter);
        this.index = index;
        this.entitySupplier = entitySupplier;
        this.key = key;
    }

    @Override
    protected DataQuery<T> newInstance(Predicate<T> filter) {
        return new LargeDataModelQuery<I, T, K2>(this.entitySupplier, this.index, this.key, filter);
    }

    @Override
    public Stream<T> getAll() {
        return this.idsAsStream().map(this.entitySupplier).filter(Objects::nonNull).filter(this.getFilter());
    }

    @Override
    public Optional<T> getFirst() {
        return this.getAll().findFirst();
    }

    private Stream<I> idsAsStream() {
        return StreamSupport.stream(Utils.filter(this.index, this.key).spliterator(), false);
    }
}

