/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.PublicTradeConfirmationQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;

@Singleton
public class PublicTradeConfirmationQueriesImpl
implements PublicTradeConfirmationQueries {
    private final SmallFastDataModel<Long, PublicTradeConfirmation> dataModel;

    @Inject
    public PublicTradeConfirmationQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(PublicTradeConfirmation.class);
    }

    @Override
    public PublicTradeConfirmation findNewestTradeConfirmationForContract(Contract contract) {
        return this.dataModel.getAllEntitiesAsStream().filter(p -> p.getContract().equals(contract)).sorted((o1, o2) -> o2.getTradeExecutionTime().compareTo(o1.getTradeExecutionTime())).findFirst().orElse(null);
    }

    @Override
    public DateTime getTimeOfOldestPublicTradeConfirmation() {
        return new SmallFastDataModelQuery<Long, PublicTradeConfirmation>(this.dataModel).getAll().map(PublicTradeConfirmation::getTradeExecutionTime).min(DateTimeComparator.getInstance()).orElse(null);
    }
}

