/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.CompoundStatus;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.comxerv.comtrader.entities.type.PutOrCall;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class Contract
extends BroadcastEntity<Long>
implements RevisionNumbered,
Comparable<Contract>,
Mergeable<Contract>,
SmallDataModelEntity,
DisplayName {
    public static final Comparator<Contract> DEFAULT_COMPARATOR = new DefaultComparator();
    public static final Comparator<Contract> DEFAULT_DISPLAY_COMPARATOR = (o1, o2) -> ComparisonChain.start().compare((Comparable<?>)((Object)o1.getProduct().getDisplayName().toUpperCase()), (Comparable<?>)((Object)o2.getProduct().getDisplayName().toUpperCase())).compare(o1.getDeliveryStart(), o2.getDeliveryStart()).compare((Comparable<?>)((Object)o1.getDisplayName().toUpperCase()), (Comparable<?>)((Object)o2.getDisplayName().toUpperCase())).result();
    private final ObjectProperty<Product> product;
    private final StringProperty name;
    private final StringProperty longName;
    private DateTime activationPoint;
    private DateTime expiryPoint;
    private DateTime deliveryStart;
    private DateTime deliveryEnd;
    private boolean betweenTradingAndDeliveryEnd;
    private long revisionNumber;
    private final CompoundStatus compoundStatus;
    private LongDisplayValue strikePrc;
    private PutOrCall putOrCall;
    private Long remoteContractId;

    public Contract(Product product) {
        this.product = new SimpleObjectProperty<Product>(product);
        this.betweenTradingAndDeliveryEnd = false;
        this.name = new SimpleStringProperty();
        this.longName = new SimpleStringProperty();
        this.compoundStatus = new CompoundStatus();
    }

    public double getDeliveryUnits() {
        return this.getProduct().getDeliveryUnits();
    }

    @Override
    public Class<Contract> getEntityClass() {
        return Contract.class;
    }

    public Exchange getExchange() {
        return this.getProduct().getExchange();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty longNameProperty() {
        return this.longName;
    }

    public PutOrCall getPutOrCall() {
        return this.putOrCall;
    }

    public void setPutOrCall(PutOrCall putOrCall) {
        this.putOrCall = putOrCall;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getLongName() {
        return (String)this.longName.get();
    }

    public void setLongName(String longName) {
        this.longName.set(longName);
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product.set(product);
    }

    public LongDisplayValue getStrikePrc() {
        return this.strikePrc;
    }

    public void setStrikePrc(LongDisplayValue strikePrc) {
        this.strikePrc = strikePrc;
    }

    public boolean isOption() {
        return this.getStrikePrc() != null && this.getPutOrCall() != null;
    }

    public DateTime getActivationPoint() {
        return this.activationPoint;
    }

    public void setActivationPoint(DateTime activationPoint) {
        this.activationPoint = activationPoint;
    }

    public DateTime getExpiryPoint() {
        return this.expiryPoint;
    }

    public void setExpiryPoint(DateTime expiryPoint) {
        this.expiryPoint = expiryPoint;
    }

    public DateTime getDeliveryStart() {
        return this.deliveryStart;
    }

    public void setDeliveryStart(DateTime deliveryStart) {
        this.deliveryStart = deliveryStart;
    }

    public DateTime getDeliveryEnd() {
        return this.deliveryEnd;
    }

    public void setDeliveryEnd(DateTime deliveryEnd) {
        this.deliveryEnd = deliveryEnd;
    }

    public boolean isBetweenTradingAndDeliveryEnd() {
        return this.betweenTradingAndDeliveryEnd;
    }

    public void setBetweenTradingAndDeliveryEnd(boolean betweenTradingAndDeliveryEnd) {
        this.betweenTradingAndDeliveryEnd = betweenTradingAndDeliveryEnd;
    }

    public Duration getDeliveryDuration() {
        return new Duration(this.getDeliveryEnd(), this.getDeliveryStart());
    }

    public Long getRemoteContractId() {
        return this.remoteContractId;
    }

    public void setRemoteContractId(Long remoteContractId) {
        this.remoteContractId = remoteContractId;
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public ContractType getType() {
        return ContractType.REGULAR;
    }

    @Override
    public int compareTo(Contract o) {
        return ((Long)this.getId()).compareTo((Long)o.getId());
    }

    public ProductType getProductType() {
        return this.getProduct().getProductType();
    }

    @Override
    public void merge(Contract other) {
        this.revisionNumber = other.getRevisionNumber();
        this.name.set(other.getName());
        this.longName.set(other.getLongName());
        this.activationPoint = other.getActivationPoint();
        this.expiryPoint = other.getExpiryPoint();
        this.deliveryStart = other.getDeliveryStart();
        this.deliveryEnd = other.getDeliveryEnd();
        this.betweenTradingAndDeliveryEnd = other.isBetweenTradingAndDeliveryEnd();
        this.strikePrc = other.getStrikePrc();
        this.putOrCall = other.getPutOrCall();
        this.compoundStatus.merge(other.getCompoundStatus());
    }

    public boolean computeBetweenTradingAndDeliveryEnd(DateTime now) {
        DateTime start = this.getCompoundStatus().getLastTradeEnd();
        DateTime end = this.getDeliveryEnd();
        return start != null && now.isAfter(start) && now.isBefore(end);
    }

    public CompoundStatus getCompoundStatus() {
        return this.compoundStatus;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public boolean supportsOpenCloseIndicator() {
        return this.getProduct().supportsOpenCloseIndicator();
    }

    private static final class DefaultComparator
    implements Comparator<Contract> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Contract o1, Contract o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int deliveryStartComparison = ObjectUtils.compare(o1.getDeliveryStart(), o2.getDeliveryStart());
            if (deliveryStartComparison == 0) {
                int deliveryEndComparison = -1 * ObjectUtils.compare(o1.getDeliveryEnd(), o2.getDeliveryEnd());
                if (deliveryEndComparison == 0) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return deliveryEndComparison;
            }
            return deliveryStartComparison;
        }
    }
}

