/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.TradeInfo;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.util.Objects;
import java.util.stream.Stream;

public class FullTrade
extends Trade
implements Mergeable<FullTrade> {
    private HalfTrade buyHalfTrade;
    private HalfTrade sellHalfTrade;

    public FullTrade() {
    }

    public FullTrade(long id) {
        super(id);
    }

    public FullTrade(FullTrade other) {
        super(other);
        this.buyHalfTrade = other.getBuyHalfTrade();
        this.sellHalfTrade = other.getSellHalfTrade();
    }

    public FullTrade(long id, TradeInfo tradeInfo, HalfTrade buy, HalfTrade sell) {
        super(id, tradeInfo);
        this.buyHalfTrade = buy;
        this.sellHalfTrade = sell;
        this.setId(id);
    }

    @Override
    public Long getTradeId() {
        return (Long)this.getId();
    }

    public Trade.OrderInfo getOrder(Direction direction) {
        return direction == Direction.BUY ? this.getBuyOrder() : this.getSellOrder();
    }

    public Trade.OrderInfo getBuyOrder() {
        if (this.buyHalfTrade == null) {
            return null;
        }
        return this.buyHalfTrade.getOrder();
    }

    public Trade.OrderInfo getSellOrder() {
        if (this.sellHalfTrade == null) {
            return null;
        }
        return this.sellHalfTrade.getOrder();
    }

    public HalfTrade getBuyHalfTrade() {
        return this.buyHalfTrade;
    }

    public void setBuyHalfTrade(HalfTrade buyHalfTrade) {
        this.buyHalfTrade = buyHalfTrade;
    }

    public HalfTrade getSellHalfTrade() {
        return this.sellHalfTrade;
    }

    public void setSellHalfTrade(HalfTrade sellHalfTrade) {
        this.sellHalfTrade = sellHalfTrade;
    }

    public Stream<HalfTrade> allHalfTrades() {
        return Stream.of(this.buyHalfTrade, this.sellHalfTrade).filter(Objects::nonNull);
    }

    public Stream<HalfTrade> updatedHalfTrades() {
        return this.allHalfTrades().filter(HalfTrade::isDirty);
    }

    public HalfTrade getHalf(Direction direction) {
        return direction == Direction.BUY ? this.buyHalfTrade : this.sellHalfTrade;
    }

    @Override
    public Class<FullTrade> getEntityClass() {
        return FullTrade.class;
    }

    @Override
    public void merge(FullTrade object) {
        super.mergeCommon(object);
        if (object.getBuyHalfTrade() != null) {
            this.setBuyHalfTrade(object.getBuyHalfTrade());
        }
        if (object.getSellHalfTrade() != null) {
            this.setSellHalfTrade(object.getSellHalfTrade());
        }
    }

    @Override
    public String toString() {
        if (this.getId() != null) {
            return ((Long)this.getId()).toString();
        }
        return "FullTrade{contract=" + String.valueOf(this.getContract()) + ", price=" + String.valueOf(this.getPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", buyHalfTrade=" + String.valueOf(this.buyHalfTrade) + ", sellHalfTrade=" + String.valueOf(this.sellHalfTrade) + "}";
    }
}

