/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.MemberType;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;

public class Member
extends BroadcastEntity<String>
implements RevisionNumbered,
Comparable<Member>,
SmallDataModelEntity,
Mergeable<Member>,
DisplayName {
    private final LongProperty revisionNumber = new SimpleLongProperty();
    private final ObjectProperty<SuspensionType> suspensionType = new SimpleObjectProperty<SuspensionType>();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<MemberType> memberType = new SimpleObjectProperty<MemberType>();
    private final ObservableValue<String> displayName = DependentBinding.get(this::computeDisplayName, this.nameProperty());

    private String computeDisplayName() {
        String currentName = this.getName();
        boolean nameEmpty = currentName == null || currentName.isEmpty();
        return (String)this.getId() + (String)(!nameEmpty ? " (" + currentName + ")" : "");
    }

    @Override
    public void merge(Member object) {
        this.setName(object.getName());
        this.setSuspensionType(object.getSuspensionType());
        this.setRevisionNumber(object.getRevisionNumber());
    }

    public ObservableValue<String> displayNameProperty() {
        return this.displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getValue();
    }

    public LongProperty revisionNumberProperty() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public SuspensionType getSuspensionType() {
        return (SuspensionType)((Object)this.suspensionType.get());
    }

    public ObjectProperty<SuspensionType> suspensionTypeProperty() {
        return this.suspensionType;
    }

    public void setSuspensionType(SuspensionType suspensionType) {
        this.suspensionType.set(suspensionType);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public MemberType getMemberType() {
        return (MemberType)((Object)this.memberType.get());
    }

    public ObjectProperty<MemberType> memberTypeProperty() {
        return this.memberType;
    }

    public void setMemberType(MemberType memberType) {
        this.memberType.set(memberType);
    }

    @Override
    public Class<Member> getEntityClass() {
        return Member.class;
    }

    @Override
    public int compareTo(Member m) {
        return ((String)this.getId()).compareTo((String)m.getId());
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public String toString() {
        return "Member{revisionNumber=" + String.valueOf(this.revisionNumber) + ", suspensionType=" + String.valueOf(this.suspensionType) + ", name=" + String.valueOf(this.name) + ", type=" + String.valueOf(this.memberType) + "}";
    }
}

