/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.TimeStampProvider;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageType;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
extends BroadcastEntity<String>
implements TimeStampProvider,
Comparable<Message>,
SmallDataModelEntity {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    private static final AtomicLong clientSeqNum = new AtomicLong(0L);
    private final DateTime timeStamp;
    private final MessageSeverity severity;
    private final String messageText;
    private final MessageType type;
    private final boolean mrktSupervisionMsg;
    private final SpecialMessage specialMessage;
    private final Exchange exchange;
    private final long deliveryOrderId;
    private static final Exchange GUI_EXCHANGE = Exchange.newBuilder().withMarketId("GUI").withName(Util.getLabel("application_name")).withApiVersion(Util.getLabel("application_version")).build();

    public static Message createServerMessage(Exchange exchange, Long seqNumber, DateTime timestamp, String messageText, MessageSeverity severity, MessageType type, boolean mrktSupervisionMsg, SpecialMessage specialMessage) {
        long deliveryOrderId = clientSeqNum.getAndIncrement();
        String entityId = seqNumber == 0L ? "CLI " + deliveryOrderId : "SRV " + seqNumber.toString();
        if (messageText == null || messageText.isEmpty() || messageText.trim().equals("null")) {
            LOG.error("Empty server message", new IllegalStateException());
            messageText = Util.getLabel("server_message_null_error");
        }
        return new Message(exchange, entityId, timestamp, messageText, severity, type, mrktSupervisionMsg, specialMessage, deliveryOrderId);
    }

    public static Message createServerMessage(Exchange exchange, Long seqNumber, DateTime timestamp, String messageText, MessageSeverity severity, MessageType type, boolean mrktSupervisionMsg) {
        return Message.createServerMessage(exchange, seqNumber, timestamp, messageText, severity, type, mrktSupervisionMsg, null);
    }

    public static Message createClientMessage(Exchange exchange, DateTime timestamp, String messageText, MessageSeverity severity) {
        return Message.createClientMessage(exchange, timestamp, messageText, severity, null);
    }

    public static Message createClientMessage(Exchange exchange, DateTime timestamp, String messageText, MessageSeverity severity, SpecialMessage specialMessage) {
        long deliveryOrderId = clientSeqNum.getAndIncrement();
        String entityId = "CLI " + deliveryOrderId;
        if (messageText == null || messageText.isEmpty() || messageText.trim().equals("null")) {
            LOG.error("Empty client message", new IllegalStateException());
            messageText = Util.getLabel("client_message_null_error");
        }
        return new Message(exchange, entityId, timestamp, messageText, severity, MessageType.GUI, false, specialMessage, deliveryOrderId);
    }

    public static Message createGuiMessage(DateTime timeStamp, String messageText, MessageSeverity severity, SpecialMessage specialMessage) {
        return Message.createClientMessage(GUI_EXCHANGE, timeStamp, messageText, severity, specialMessage);
    }

    private Message(Exchange exchange, String entityId, DateTime timestamp, String messageText, MessageSeverity severity, MessageType type, boolean mrktSupervisionMsg, SpecialMessage specialMessage, long deliveryOrderId) {
        this.setId(entityId);
        this.exchange = exchange;
        this.timeStamp = timestamp;
        this.severity = severity;
        this.messageText = messageText;
        this.type = type;
        this.mrktSupervisionMsg = mrktSupervisionMsg;
        this.specialMessage = specialMessage;
        this.deliveryOrderId = deliveryOrderId;
    }

    @Override
    public Class<Message> getEntityClass() {
        return Message.class;
    }

    public MessageType getType() {
        return this.type;
    }

    @Override
    public DateTime getTimeStamp() {
        return this.timeStamp;
    }

    public MessageSeverity getSeverity() {
        return this.severity;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public SpecialMessage getSpecialMessage() {
        return this.specialMessage;
    }

    public boolean isMrktSupervisionMsg() {
        return this.mrktSupervisionMsg;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public String toString() {
        return "Message [id=" + (String)this.getId() + ", type=" + String.valueOf(this.type) + ", severity=" + String.valueOf(this.severity) + ", timeStamp=" + String.valueOf(this.timeStamp) + ", messageText=" + this.messageText + ", mrktSupervisionMsg=" + this.mrktSupervisionMsg + "]";
    }

    @Override
    public int compareTo(@Nonnull Message o) {
        return Long.compare(this.deliveryOrderId, o.deliveryOrderId);
    }
}

