/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntrySource;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public abstract class CommonOrderbookEntry {
    private final long addedTimestamp;
    private final ObjectProperty<LongDisplayValue> accQuantity;
    private final ObjectProperty<LongDisplayValue> price;
    private final ObjectProperty<LongDisplayValue> quantity;
    private final OrderType orderType;
    private final ObjectProperty<LongDisplayValue> vwap;
    private boolean containsOwnOrder;
    private boolean containsOwnUserOrder;
    private boolean containsBalOrder;
    private boolean accumulatedTradable;
    private final Orderbook orderbook;
    private final Direction direction;

    protected CommonOrderbookEntry(long addedTimestamp, LongDisplayValue accQuantity, LongDisplayValue price, LongDisplayValue quantity, LongDisplayValue vwap, Orderbook orderbook, Direction direction, OrderType orderType, boolean containsOwnOrder, boolean containsOwnUserOrder, boolean containsBalOrder) {
        this.addedTimestamp = addedTimestamp;
        this.accQuantity = new SimpleObjectProperty<LongDisplayValue>(accQuantity);
        this.price = new SimpleObjectProperty<LongDisplayValue>(price);
        this.quantity = new SimpleObjectProperty<LongDisplayValue>(quantity);
        this.vwap = new SimpleObjectProperty<LongDisplayValue>(vwap);
        this.orderbook = orderbook;
        this.direction = direction;
        this.orderType = orderType;
        this.containsOwnOrder = containsOwnOrder;
        this.containsOwnUserOrder = containsOwnUserOrder;
        this.containsBalOrder = containsBalOrder;
        this.accumulatedTradable = false;
    }

    public Orderbook getOrderbook() {
        return this.orderbook;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public long getAddedTimestamp() {
        return this.addedTimestamp;
    }

    public LongDisplayValue getAccQuantity() {
        return (LongDisplayValue)this.accQuantity.get();
    }

    public ObservableValue<LongDisplayValue> accQuantityProperty() {
        return this.accQuantity;
    }

    void setAccQuantity(LongDisplayValue accQuantity) {
        this.accQuantity.set(accQuantity);
    }

    public LongDisplayValue getPrice() {
        return (LongDisplayValue)this.price.get();
    }

    public ObservableValue<LongDisplayValue> priceProperty() {
        return this.price;
    }

    void setPrice(LongDisplayValue price) {
        this.price.set(price);
    }

    public LongDisplayValue getQuantity() {
        return (LongDisplayValue)this.quantity.get();
    }

    public ObservableValue<LongDisplayValue> quantityProperty() {
        return this.quantity;
    }

    ObjectProperty<LongDisplayValue> quantityPropertyModifiable() {
        return this.quantity;
    }

    void setQuantity(LongDisplayValue quantity) {
        this.quantity.set(quantity);
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public LongDisplayValue getVwap() {
        return (LongDisplayValue)this.vwap.get();
    }

    public ObservableValue<LongDisplayValue> vwapProperty() {
        return this.vwap;
    }

    void setVwap(LongDisplayValue vwap) {
        this.vwap.set(vwap);
    }

    public boolean isContainsOwnOrder() {
        return this.containsOwnOrder;
    }

    void setContainsOwnOrder(boolean containsOwnOrder) {
        this.containsOwnOrder = containsOwnOrder;
    }

    public boolean isContainsOwnUserOrder() {
        return this.containsOwnUserOrder;
    }

    void setContainsOwnUserOrder(boolean containsOwnUserOrder) {
        this.containsOwnUserOrder = containsOwnUserOrder;
    }

    public boolean isContainsBalOrder() {
        return this.containsBalOrder;
    }

    void setContainsBalOrder(boolean containsBalOrder) {
        this.containsBalOrder = containsBalOrder;
    }

    public boolean isAccumulatedTradable() {
        return this.accumulatedTradable;
    }

    void setAccumulatedTradable(boolean accumulatedTradable) {
        this.accumulatedTradable = accumulatedTradable;
    }

    public OrderbookEntrySource getSource() {
        return OrderbookEntrySource.OUTRIGHT;
    }

    public abstract LongDisplayValue getTradableQuantity();

    public abstract LongDisplayValue getOwnQuantity();

    public abstract ObservableValue<LongDisplayValue> ownQuantityProperty();

    public abstract OrderbookEntryType getType();

    public String toString() {
        return "COE{prc=" + String.valueOf(this.price.get()) + ", qty=" + String.valueOf(this.getQuantity()) + "}";
    }
}

