/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryFilter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;

public class FilteredOrderbookEntries
extends OrderbookEntries {
    private final BatchUpdateListener<OrderbookEntry> listener;

    public FilteredOrderbookEntries(final Orderbook orderbook, OrderbookEntries wrapped, final OrderbookEntryFilter filter) {
        super(wrapped.getDirection());
        for (OrderbookEntry entry : wrapped.getEntries()) {
            if (!filter.accepts(orderbook, entry)) continue;
            this.add(entry);
        }
        this.listener = new BatchUpdateListener<OrderbookEntry>(){

            @Override
            public BatchUpdateListener.NotificationResult batchStarted() {
                FilteredOrderbookEntries.super.batchStarted();
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult batchFinished() {
                FilteredOrderbookEntries.super.batchFinished();
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult itemAdded(OrderbookEntry item) {
                if (filter.accepts(orderbook, item)) {
                    FilteredOrderbookEntries.super.add(item);
                }
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult itemRemoved(OrderbookEntry item) {
                FilteredOrderbookEntries.super.remove(item);
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        wrapped.addListener((BatchUpdateListener<OrderbookEntry>)new WeakBatchUpdateListener<OrderbookEntry>(this.listener));
    }
}

