/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.BatchedCounter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.BatchedCumulativeQuantity;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryLookup;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;

public class PriceGroupedOrderbookEntry
extends CommonOrderbookEntry
implements Comparable<PriceGroupedOrderbookEntry> {
    private final BatchedCumulativeQuantity tradableQuantity;
    private final BatchedCumulativeQuantity quantity;
    private final BatchedCumulativeQuantity ownQuantity;
    private final BatchedCounter ownUserEntryCount;
    private final BatchedCounter balEntryCount;

    public PriceGroupedOrderbookEntry(Orderbook orderbook, LongDisplayValue price, int quantityShift, Direction direction, long addedTimestamp) {
        super(addedTimestamp, LongDisplayValue.toZero(quantityShift), price, LongDisplayValue.toZero(quantityShift), price.toZero(), orderbook, direction, OrderType.REGULAR, false, false, false);
        this.tradableQuantity = new BatchedCumulativeQuantity(quantityShift);
        this.quantity = new BatchedCumulativeQuantity(quantityShift, this.quantityPropertyModifiable());
        this.ownQuantity = new BatchedCumulativeQuantity(quantityShift);
        this.ownUserEntryCount = new BatchedCounter(this::setContainsOwnUserOrder);
        this.balEntryCount = new BatchedCounter(this::setContainsBalOrder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceGroupedOrderbookEntry that = (PriceGroupedOrderbookEntry)o;
        if (this.getOrderbook() != null ? !this.getOrderbook().equals(that.getOrderbook()) : that.getOrderbook() != null) {
            return false;
        }
        return !(this.getPrice() != null ? !this.getPrice().equals(that.getPrice()) : that.getPrice() != null);
    }

    public int hashCode() {
        int result = this.getPrice() != null ? this.getPrice().hashCode() : 0;
        result = 31 * result + (this.getOrderbook() != null ? this.getOrderbook().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(PriceGroupedOrderbookEntry o) {
        return this.getPrice().compareTo(o.getPrice()) * (this.getDirection().isBuy() ? -1 : 1);
    }

    void resetTradability() {
        this.tradableQuantity.reset();
    }

    void addTradableQuantity(OrderbookEntry entry) {
        this.tradableQuantity.add(entry.getQuantity());
    }

    void removeTradableQuantity(OrderbookEntry entry) {
        this.tradableQuantity.remove(entry.getQuantity());
    }

    void add(OrderbookEntry entry) {
        this.quantity.add(entry.getQuantity());
        this.addOwnQuantity(entry);
        if (entry.getOrderType() == OrderType.BALANCE) {
            this.balEntryCount.add();
        }
    }

    void resetOwnQuantity() {
        this.ownQuantity.reset();
        this.ownUserEntryCount.reset();
    }

    void addOwnQuantity(OrderbookEntry entry) {
        Long orderId = entry.getOrderId();
        OrderbookEntryLookup orderbookEntryLookup = this.getOrderbook().getOrderbookEntryLookup();
        boolean ownUserOrder = orderbookEntryLookup.isOwnUserOrder(orderId);
        boolean ownOrder = ownUserOrder || orderbookEntryLookup.isOwnOrder(orderId);
        entry.setOwnOrder(ownOrder);
        entry.setOwnUserOrder(ownUserOrder);
        if (ownOrder) {
            this.ownQuantity.add(entry.getRemainingQuantity());
        }
        if (ownUserOrder) {
            this.ownUserEntryCount.add();
        }
    }

    void remove(OrderbookEntry entry) {
        this.quantity.remove(entry.getQuantity());
        if (entry.isOwnOrder()) {
            this.ownQuantity.remove(entry.getRemainingQuantity());
        }
        if (entry.isOwnUserOrder()) {
            this.ownUserEntryCount.remove();
        }
        if (entry.getOrderType() == OrderType.BALANCE) {
            this.balEntryCount.remove();
        }
    }

    void update() {
        this.quantity.flush();
        this.ownQuantity.flush();
        this.tradableQuantity.flush();
        this.setContainsOwnOrder(!this.ownQuantity.isEmpty());
        this.ownUserEntryCount.flush();
        this.balEntryCount.flush();
    }

    boolean isEmpty() {
        return this.quantity.isEmpty();
    }

    public static Comparator<PriceGroupedOrderbookEntry> getPriceGroupedEntryPriceAscComparator() {
        return Comparator.comparing(CommonOrderbookEntry::getPrice);
    }

    public static Comparator<PriceGroupedOrderbookEntry> getPriceGroupedEntryPriceDescComparator() {
        return (o1, o2) -> o2.getPrice().compareTo(o1.getPrice());
    }

    public static Comparator<PriceGroupedOrderbookEntry> getDefaultComparator(@Nonnull Direction direction) {
        return Direction.BUY.equals(direction) ? PriceGroupedOrderbookEntry.getPriceGroupedEntryPriceDescComparator() : PriceGroupedOrderbookEntry.getPriceGroupedEntryPriceAscComparator();
    }

    @Override
    public String toString() {
        return "PGE{prc=" + String.valueOf(this.getPrice()) + ", qty=" + String.valueOf(this.getQuantity()) + "}";
    }

    public String toLongString() {
        return "PGE{prc=" + String.valueOf(this.getPrice()) + ", qty=" + String.valueOf(this.getQuantity()) + ", firmQty=" + String.valueOf(this.getQuantity()) + ", ownFirmQty=" + String.valueOf(this.getOwnQuantity()) + ", accQty=" + String.valueOf(this.getAccQuantity()) + ", vwap=" + String.valueOf(this.getVwap()) + ", ownOrdr=" + this.isContainsOwnOrder() + ", ownUsrOrdr=" + this.isContainsOwnUserOrder() + ", balOrdr=" + this.isContainsBalOrder() + "}";
    }

    @Override
    public LongDisplayValue getOwnQuantity() {
        return (LongDisplayValue)this.ownQuantity.targetQuantityProperty().get();
    }

    @Override
    public ObservableValue<LongDisplayValue> ownQuantityProperty() {
        return this.ownQuantity.targetQuantityProperty();
    }

    @Override
    public LongDisplayValue getTradableQuantity() {
        return (LongDisplayValue)this.tradableQuantity.targetQuantityProperty().get();
    }

    @Override
    public OrderbookEntryType getType() {
        return OrderbookEntryType.AGGREGATED;
    }
}

