/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class VWapUtil {
    private static final int INTERMEDIATE_RESULTS_PRECISION = 10;

    private VWapUtil() {
    }

    protected static void updateCanonicalVwapAndAccQty(List<? extends CommonOrderbookEntry> entries2, int fromIndex) {
        BigDecimal accQty = BigDecimal.ZERO;
        BigDecimal vWapNumerator = BigDecimal.ZERO;
        for (int i = 0; i < entries2.size(); ++i) {
            CommonOrderbookEntry entry = entries2.get(i);
            BigDecimal quantity = entry.getQuantity().getDisplayValue();
            accQty = accQty.add(quantity);
            entry.setAccQuantity(new LongDisplayValue(accQty));
            if (accQty.compareTo(BigDecimal.ZERO) == 0) {
                entry.setAccQuantity(LongDisplayValue.ZERO);
                continue;
            }
            vWapNumerator = vWapNumerator.add(entry.getPrice().getDisplayValue().multiply(quantity)).setScale(entry.getPrice().getShift() + entry.getQuantity().getShift() + 1);
            if (i < fromIndex) continue;
            BigDecimal vwap = vWapNumerator.divide(accQty, RoundingMode.HALF_UP);
            BigDecimal vwapRounded = vwap.setScale(entry.getPrice().getShift(), RoundingMode.HALF_UP);
            entry.setVwap(new LongDisplayValue(vwapRounded));
        }
    }

    protected static void updateBlockVwapAndAccQty(List<? extends CommonOrderbookEntry> entries2, List<Orderbook> orderbooksForVwapCalculation, Direction direction) {
        if (!entries2.isEmpty() && !orderbooksForVwapCalculation.isEmpty()) {
            int quantityShift = entries2.get(0).getQuantity().getShift();
            int priceShift = entries2.get(0).getPrice().getShift();
            List<List<ExtendedOrderbookEntry>> orderbooks = orderbooksForVwapCalculation.stream().map(orderbook -> direction.isBuy() ? orderbook.getExtendedBuys().getEntries() : orderbook.getExtendedSells().getEntries()).toList();
            LongDisplayValue accQty = new LongDisplayValue(0L, quantityShift);
            for (CommonOrderbookEntry commonOrderbookEntry : entries2) {
                LongDisplayValue vwap = VWapUtil.computeBlockVwapForEntry(orderbooks, commonOrderbookEntry.getQuantity(), priceShift);
                commonOrderbookEntry.setVwap(vwap);
                accQty = accQty.add(commonOrderbookEntry.getQuantity().getValue());
                commonOrderbookEntry.setAccQuantity(accQty);
            }
        }
    }

    protected static LongDisplayValue computeVwap(LongDisplayValue price, LongDisplayValue quantity, Direction direction, List<? extends CommonOrderbookEntry> entries2, ExecutionRestriction executionRestriction) {
        boolean isFOKorAON;
        if (price == null || quantity == null || entries2.isEmpty()) {
            return null;
        }
        BigDecimal vwapPartNumerator = BigDecimal.ZERO;
        long targetQuantity = quantity.getValue();
        long quantityMatched = 0L;
        int priceShift = price.getShift();
        int quantityShift = quantity.getShift();
        for (CommonOrderbookEntry commonOrderbookEntry : entries2) {
            if ((commonOrderbookEntry.getPrice().compareTo(price) < 0 || direction.isBuy()) && (commonOrderbookEntry.getPrice().compareTo(price) > 0 || !direction.isBuy())) continue;
            long orderQuantity = commonOrderbookEntry.getQuantity().getValue();
            if (quantityMatched + orderQuantity < targetQuantity) {
                vwapPartNumerator = VWapUtil.computeVwapNumeratorAfterAddingAllQuantity(vwapPartNumerator, commonOrderbookEntry.getQuantity(), commonOrderbookEntry.getPrice());
                quantityMatched += orderQuantity;
                continue;
            }
            if (quantityMatched + orderQuantity < targetQuantity) continue;
            vwapPartNumerator = VWapUtil.computeVwapNumeratorAfterAddingRemainingQuantity(vwapPartNumerator, quantity, quantityMatched, commonOrderbookEntry.getPrice());
            quantityMatched = targetQuantity;
            break;
        }
        boolean bl = isFOKorAON = ExecutionRestriction.ALL_OR_NOTHING.equals(executionRestriction) || ExecutionRestriction.FILL_OR_KILL.equals(executionRestriction);
        if (isFOKorAON && quantityMatched >= targetQuantity || !isFOKorAON && quantityMatched > 0L) {
            return new LongDisplayValue(vwapPartNumerator.divide(new BigDecimal(quantityMatched).movePointLeft(quantityShift), priceShift, RoundingMode.HALF_UP));
        }
        return null;
    }

    protected static LongDisplayValue computeBlockVwap(LongDisplayValue price, LongDisplayValue quantity, List<List<ExtendedOrderbookEntry>> orderbooks) {
        if (price == null || quantity == null || quantity.getValue() == 0L || orderbooks.isEmpty()) {
            return null;
        }
        return VWapUtil.computeBlockVwapForEntry(orderbooks, quantity, price.getShift());
    }

    private static LongDisplayValue computeBlockVwapForEntry(List<List<ExtendedOrderbookEntry>> orderbooks, LongDisplayValue quantity, int priceShift) {
        long targetQuantity = quantity.getValue();
        BigDecimal vwapSum = BigDecimal.ZERO;
        int numberOfOrderbooksWithSufficientQuantity = 0;
        block0: for (List<ExtendedOrderbookEntry> entries2 : orderbooks) {
            long quantityMatched = 0L;
            BigDecimal vwapPartNumerator = BigDecimal.ZERO;
            for (CommonOrderbookEntry commonOrderbookEntry : entries2) {
                long orderQuantity = commonOrderbookEntry.getQuantity().getValue();
                if (quantityMatched + orderQuantity < targetQuantity) {
                    vwapPartNumerator = VWapUtil.computeVwapNumeratorAfterAddingAllQuantity(vwapPartNumerator, commonOrderbookEntry.getQuantity(), commonOrderbookEntry.getPrice());
                    quantityMatched += orderQuantity;
                    continue;
                }
                if (quantityMatched + orderQuantity < targetQuantity) continue;
                vwapPartNumerator = VWapUtil.computeVwapNumeratorAfterAddingRemainingQuantity(vwapPartNumerator, quantity, quantityMatched, commonOrderbookEntry.getPrice());
                BigDecimal vwapForGivenOrderbook = vwapPartNumerator.divide(quantity.getDisplayValue(), 10, RoundingMode.HALF_UP);
                vwapSum = vwapSum.add(vwapForGivenOrderbook);
                ++numberOfOrderbooksWithSufficientQuantity;
                continue block0;
            }
        }
        if (!orderbooks.isEmpty() && numberOfOrderbooksWithSufficientQuantity == orderbooks.size()) {
            return new LongDisplayValue(vwapSum.divide(new BigDecimal(numberOfOrderbooksWithSufficientQuantity), priceShift, RoundingMode.HALF_UP));
        }
        return null;
    }

    private static BigDecimal computeVwapNumeratorAfterAddingRemainingQuantity(BigDecimal vwapNumerator, LongDisplayValue nextEntryQuantity, long alreadyMatchedQuantity, LongDisplayValue price) {
        BigDecimal remainingQuantity = nextEntryQuantity.getDisplayValue().subtract(new BigDecimal(alreadyMatchedQuantity).movePointLeft(nextEntryQuantity.getShift()));
        return vwapNumerator.add(price.getDisplayValue().multiply(remainingQuantity));
    }

    private static BigDecimal computeVwapNumeratorAfterAddingAllQuantity(BigDecimal vwapNumerator, LongDisplayValue nextEntryQuantity, LongDisplayValue price) {
        return vwapNumerator.add(price.getDisplayValue().multiply(nextEntryQuantity.getDisplayValue()));
    }
}

