/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.session;

import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public class Session {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final String id;
    private volatile Long remoteId;
    private final ConnectionParameters connectionParameters;
    private final Exchange exchange;
    private final DateTime createdAt;
    private Long lastTradeCancelPopupTS;
    private boolean tradeCancelPopupGrouping;

    public Session(ConnectionParameters connectionParameters, Exchange exchange, DateTime now) {
        if (connectionParameters == null || exchange == null) {
            throw new NullPointerException();
        }
        this.createdAt = now;
        this.connectionParameters = connectionParameters;
        this.exchange = exchange;
        this.id = "LocalId:" + idGenerator.getAndIncrement();
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public Long getRemoteId() {
        return this.remoteId;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public String getRabbitUser() {
        return this.connectionParameters.getRabbitUser();
    }

    public Long getLastTradeCancelPopupTS() {
        return this.lastTradeCancelPopupTS;
    }

    public void setLastTradeCancelPopupTS(Long lastTradeCancelPopupTS) {
        this.lastTradeCancelPopupTS = lastTradeCancelPopupTS;
    }

    public boolean isTradeCancelPopupGrouping() {
        return this.tradeCancelPopupGrouping;
    }

    public void setTradeCancelPopupGrouping(boolean tradeCancelPopupGrouping) {
        this.tradeCancelPopupGrouping = tradeCancelPopupGrouping;
    }

    public void init(Long remoteId) {
        if (remoteId == null) {
            throw new NullPointerException();
        }
        this.remoteId = remoteId;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId().equals(((Session)o).getId());
    }

    public String toString() {
        return "Session(" + this.exchange.getId() + "," + this.connectionParameters.getRabbitUser() + "," + this.id + "," + this.remoteId + ")";
    }
}

