/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.CachingClassLoader;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXMLLoaderWithContext {
    private static final Logger LOG = LoggerFactory.getLogger(FXMLLoaderWithContext.class);
    private static final CachingClassLoader CACHING_CLASS_LOADER = CachingClassLoader.getClassLoader();

    private FXMLLoaderWithContext() {
    }

    public static Parent load(ApplicationContext appContext, URL resourcePath) {
        try {
            ApplicationContextHolder.push(appContext);
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setClassLoader(CACHING_CLASS_LOADER);
            fxmlLoader.setLocation(resourcePath);
            fxmlLoader.setResources(Util.getLabels());
            Parent parent = (Parent)fxmlLoader.load();
            return parent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ApplicationContextHolder.pop();
        }
    }

    public static void loadCustomComponent(ApplicationContext appContext, Object component, URL url) {
        ApplicationContextHolder.push(appContext);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setClassLoader(CACHING_CLASS_LOADER);
        fxmlLoader.setLocation(url);
        fxmlLoader.setResources(Util.getLabels());
        fxmlLoader.setRoot(component);
        fxmlLoader.setController(component);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            ApplicationContextHolder.pop();
        }
    }

    public static void loadCustomComponent(ApplicationContext appContext, Object component) {
        FXMLLoaderWithContext.loadCustomComponent(appContext, component, component.getClass().getResource(component.getClass().getSimpleName() + ".fxml"));
    }

    public static void loadCustomComponent(Object component) {
        FXMLLoaderWithContext.loadCustomComponent(null, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createComponent(Class<?> clazz, ApplicationContext appContext) {
        try {
            ApplicationContextHolder.push(appContext);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            LOG.error("Error while creating component " + clazz.getName(), e);
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            ApplicationContextHolder.pop();
        }
    }

    public static ApplicationContext getAppContext() {
        return ApplicationContextHolder.getCurrentValue();
    }

    private static final class ApplicationContextHolder {
        private static final ThreadLocal<ApplicationContextHolder> CURRENT_VALUE = new ThreadLocal();
        private final ApplicationContextHolder previous;
        private final ApplicationContext value;

        private ApplicationContextHolder(ApplicationContext applicationContext) {
            this.value = applicationContext;
            this.previous = CURRENT_VALUE.get();
            CURRENT_VALUE.set(this);
        }

        protected static void push(ApplicationContext applicationContext) {
            new ApplicationContextHolder(applicationContext);
        }

        protected static void pop() {
            if (CURRENT_VALUE.get() != null) {
                CURRENT_VALUE.get().revertToPrevious();
            }
        }

        private void revertToPrevious() {
            CURRENT_VALUE.set(this.previous);
        }

        protected static ApplicationContext getCurrentValue() {
            return CURRENT_VALUE.get() != null ? ApplicationContextHolder.CURRENT_VALUE.get().value : null;
        }
    }
}

