/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.MemoryWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.commons.lang3.SystemUtils;

@Singleton
public class AboutPanel
extends BorderPane {
    private final ObservableValue<Exchange> activeExchange;
    private final Stage aboutStage;
    private final ConnectionParametersWithFallback connectionParameters;
    @FXML
    private Label verLabel;
    @FXML
    private Label envLabel;
    @FXML
    private Label jreLabel;
    @FXML
    private Label jvmLabel;
    @FXML
    private Label osLabel;
    @FXML
    private Label exchangeLabel;
    @FXML
    private Label backendVersionLabel;
    @FXML
    private MemoryWidget memoryWidget;
    private final VersionService versionService;

    @Inject
    public AboutPanel(ApplicationContext appContext) {
        this.aboutStage = appContext.getService(UtilityStages.class).withKey(AboutPanel.class.getName()).withStageStyle(StageStyle.DECORATED).withRoot(this).get();
        this.aboutStage.setWidth(500.0);
        this.aboutStage.setAlwaysOnTop(true);
        this.aboutStage.setTitle(Util.getLabel("commons_about"));
        this.versionService = appContext.getService(VersionService.class);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.connectionParameters = appContext.getService(ConnectionParametersWithFallback.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.verLabel.setText(Util.getLabel("application_name") + " " + this.versionService.getComtraderVersion() + " " + this.versionService.getComtraderTS());
        this.envLabel.setText("ENV: " + this.connectionParameters.getExchange().getName() + " " + this.connectionParameters.getEnvironmentName());
        this.jreLabel.setText("JRE: " + SystemUtils.JAVA_RUNTIME_VERSION);
        this.jvmLabel.setText("JVM: " + SystemUtils.JAVA_VM_NAME + " by " + SystemUtils.JAVA_VM_VENDOR);
        this.osLabel.setText("OS: " + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION + " " + SystemUtils.OS_ARCH);
        this.exchangeLabel.textProperty().bind(DependentBinding.get(Exchange::getDisplayName, this.activeExchange));
        this.backendVersionLabel.textProperty().bind(DependentBinding.get(e -> e.getSystemInfo().getBackendVersion(), this.activeExchange));
    }

    @FXML
    public void copyToClipboard() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.verLabel.getText()).append(System.lineSeparator());
        stringBuilder.append(this.envLabel.getText()).append(System.lineSeparator());
        stringBuilder.append(this.jreLabel.getText()).append(System.lineSeparator());
        stringBuilder.append(this.jvmLabel.getText()).append(System.lineSeparator());
        stringBuilder.append(this.osLabel.getText()).append(System.lineSeparator());
        stringBuilder.append(this.memoryWidget.getText()).append(System.lineSeparator());
        if (this.activeExchange.getValue() != null) {
            stringBuilder.append(this.activeExchange.getValue()).append(" ").append(this.activeExchange.getValue().getSystemInfo().getBackendVersion()).append(System.lineSeparator());
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(stringBuilder.toString());
        Clipboard.getSystemClipboard().setContent(content);
    }

    public void showDialog() {
        this.aboutStage.show();
        this.aboutStage.toFront();
    }

    public void close() {
        this.aboutStage.close();
    }
}

