/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ProductFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PersistentOrderbookId;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractStatusFilterChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryDateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryDateFilterChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.LimitChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ContractListView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ContractRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.EmptyOrderbookPanelPlaceholder;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookPanelContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTree;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SlideInContractTreePane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.GlobalOrderbookSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingChangeListener;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingRecord;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingService;
import com.deutscheboerse.comxerv.comtrader.service.event.FullHourEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrderbookPanel<O extends OrderbookValueWrapper, A extends BroadcastEntity<String> & DisplayImage>
extends AbstractPanel
implements OrderbookRemovalCallback,
ContractListView,
AlertingChangeListener {
    public static final int DEFAULT_ORDERBOOK_DEPTH = 5;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOrderbookPanel.class);
    protected final ObservableList<O> orderbooks;
    protected final FilteredList<O> filteredOrderbooks;
    private final DragAndDropService dragAndDropService;
    protected final AlertingService alertingService;
    private final SmallFastDataModel<String, Orderbook> orderbookDataModel;
    protected final OrderbookQueries orderbookQueries;
    protected final ContractQueries contractQueries;
    protected final OrderPreferencesService orderPreferencesService;
    protected final UserService userService;
    protected final AssignmentService assignmentService;
    private final BackendConnectionGateway backendConnectionGateway;
    private final AtomicInteger orderbooksBeingAdded = new AtomicInteger(0);
    @FXML
    protected AbstractAreaChoiceBox<A> deliveryAreaChoiceBox;
    @FXML
    protected LimitChoiceBox limitChoiceBox;
    @FXML
    protected DeliveryDateFilterChoiceBox deliveryDateFilterChoiceBox;
    @FXML
    protected ContractStatusFilterChoiceBox contractStatusFilterChoiceBox;
    @FXML
    protected EmptyOrderbookPanelPlaceholder emptyOrderbookPanelPlaceholder;
    @FXML
    protected BottomToolbar bottomToolbar;
    private AbstractDataModelListener<Orderbook> orderbookAbstractDataModelListener;
    protected final SlideInContractTreePane contractTreePane;
    private final OrderbookPanelContractTreeContext contractTreeContext;

    public AbstractOrderbookPanel(ApplicationContext appContext, Predicate<Contract> contractFilter, Predicate<Product> productFilter) {
        super(appContext);
        this.orderbooks = FXCollections.observableArrayList();
        this.filteredOrderbooks = new FilteredList<O>(this.orderbooks);
        this.contractTreeContext = new OrderbookPanelContractTreeContext(appContext, this, contractFilter, productFilter);
        this.contractTreePane = new SlideInContractTreePane(appContext, this.contractTreeContext);
        this.dragAndDropService = this.getAppContext().getService(DragAndDropService.class);
        this.backendConnectionGateway = this.getAppContext().getService(BackendConnectionGateway.class);
        this.orderPreferencesService = this.getAppContext().getService(OrderPreferencesService.class);
        this.userService = this.getAppContext().getService(UserService.class);
        this.assignmentService = this.getAppContext().getService(AssignmentService.class);
        this.orderbookDataModel = appContext.getSmallDataModel(Orderbook.class);
        this.orderbookQueries = appContext.getService(OrderbookQueries.class);
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.alertingService = appContext.getService(AlertingService.class);
        this.orderbookAbstractDataModelListener = new AbstractDataModelListener<Orderbook>(){

            @Override
            public DataModelListener.NotificationResult notifyRemove(Orderbook removed) {
                AbstractOrderbookPanel.this.removeOrHideOrderbook(removed);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll(Collection<Orderbook> objects) {
                AbstractOrderbookPanel.this.removeOrHideOrderbooks(objects);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                AbstractOrderbookPanel.this.removeAllOrderbooks();
                return DataModelListener.NotificationResult.REMOVE_LISTENER;
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getCenter().setOnDragOver(this::onDraggedOver);
        this.getCenter().setOnDragDropped(this::onDragDropped);
        this.emptyOrderbookPanelPlaceholder.setOnOpenInstruments(this.contractTreePane::showContractTree);
        this.emptyOrderbookPanelPlaceholder.placeholderTypeProperty().bind(Bindings.when(Bindings.isEmpty(this.orderbooks)).then(EmptyOrderbookPanelPlaceholder.PlaceholderType.NO_ORDERBOOKS_LOADED).otherwise(EmptyOrderbookPanelPlaceholder.PlaceholderType.NO_ORDERBOOKS_MATCH_FILTER));
        this.deliveryDateFilterChoiceBox.valueProperty().addListener(observable2 -> this.refilterOrderbooks());
        if (this.contractStatusFilterChoiceBox != null) {
            this.contractStatusFilterChoiceBox.selectedContractStatusesProperty().addListener(observable2 -> this.refilterOrderbooks());
        }
        this.deliveryAreaChoiceBox.valueProperty().addListener((x$0, x$1, x$2) -> this.areaChanged(x$0, (BroadcastEntity)x$1, (BroadcastEntity)x$2));
        this.deliveryAreaChoiceBox.setValue(null);
        this.orderbookDataModel.registerListener(new WeakDataModelListener<Orderbook>(this.orderbookAbstractDataModelListener));
        final ObservableValue<Boolean> visibilityOfProductNavigatorProperty = this.getAppContext().getService(GlobalOrderbookSettingsService.class).visibilityOfProductNavigatorProperty();
        this.leftProperty().bind(new WeakObservableValue<Node>(new DependentBinding<Node>(new Observable[]{visibilityOfProductNavigatorProperty}){

            @Override
            protected Node computeValue() {
                if (((Boolean)visibilityOfProductNavigatorProperty.getValue()).booleanValue()) {
                    return AbstractOrderbookPanel.this.contractTreePane;
                }
                return null;
            }
        }));
        this.alertingService.addAlertingChangeListener(this);
    }

    @Override
    public void destroy() {
        this.alertingService.removeAlertingChangeListener(this);
        super.destroy();
    }

    private void areaChanged(ObservableValue<? extends A> observable2, A oldValue, A newValue) {
        if (newValue != null) {
            this.filterOrderBooks((BroadcastEntity<String>)newValue);
        } else {
            this.refilterOrderbooks();
        }
    }

    private void onDraggedOver(DragEvent event) {
        boolean dragboardHasRelevantContent;
        Dragboard db = event.getDragboard();
        boolean panelIsNotBusy = this.orderbooksBeingAdded.get() == 0;
        boolean bl = dragboardHasRelevantContent = this.dragAndDropService.hasContractList(db) || this.dragAndDropService.hasProductList(db);
        if (panelIsNotBusy && dragboardHasRelevantContent) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    private void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean anyContractsDropped = this.addDroppedContent(db);
        event.setDropCompleted(anyContractsDropped);
        event.consume();
    }

    @Override
    public void removeOrHideOrderbook(Orderbook orderbook) {
        List<OrderbookValueWrapper> orderbookWrapper = this.orderbooks.stream().filter(orderbookItem -> orderbook.equals(orderbookItem.getOrderbook())).toList();
        Optional<Orderbook> remoteOrderbook = this.orderbookQueries.findByContractIdAndDeliveryAreaId(orderbook.getContract().getRemoteContractId(), orderbook.getDeliveryAreaId());
        Optional<Contract> linkedContract = this.contractQueries.findByRemoteContractId((Long)orderbook.getContract().getId());
        Optional linkedOrderbook = linkedContract.flatMap(contract -> this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), orderbook.getDeliveryAreaId()));
        if (remoteOrderbook.isPresent() && remoteOrderbook.get().getContractStatus().isVisible() && !orderbook.getContractStatus().isVisible()) {
            orderbookWrapper.forEach(o -> o.setOrderbook((Orderbook)remoteOrderbook.get()));
        } else if (linkedOrderbook.isPresent() && ((Orderbook)linkedOrderbook.get()).getContractStatus().isVisible() && !orderbook.getContractStatus().isVisible()) {
            orderbookWrapper.forEach(o -> o.setOrderbook((Orderbook)linkedOrderbook.get()));
        } else {
            this.orderbooks.removeIf(orderbookItem -> orderbook.equals(orderbookItem.getOrderbook()));
        }
        this.refilterOrderbooks();
    }

    private void removeOrHideOrderbooks(Collection<Orderbook> orderbooksToRemove) {
        this.orderbooks.removeIf(orderbookItem -> orderbooksToRemove.contains(orderbookItem.getOrderbook()));
        this.refilterOrderbooks();
    }

    @Override
    public void removeOrderbookItem(OrderbookValueWrapper orderbookItem) {
        this.orderbooks.remove(orderbookItem);
    }

    @Override
    public void removeContracts(List<Contract> removedContracts) {
        this.removeOrderbookItemsIf(orderbookItem -> orderbookItem.getOrderbook() != null && removedContracts.contains(orderbookItem.getOrderbook().getContract()));
    }

    private void removeAllOrderbooks() {
        this.removeOrderbookItemsIf(orderbookItem -> orderbookItem.getOrderbook() != null);
    }

    private void removeOrderbookItemsIf(Predicate<O> filter) {
        List orderbookItemsToRemove = this.orderbooks.stream().filter(filter).toList();
        this.orderbooks.removeAll(orderbookItemsToRemove);
        this.refilterOrderbooks();
    }

    private void filterOrderBooks(BroadcastEntity<String> area) {
        ArrayList<O> orderbookWrappers = new ArrayList<O>(this.orderbooks);
        for (OrderbookValueWrapper orderbookWrapper : orderbookWrappers) {
            Orderbook oldOrderbook = orderbookWrapper.getOrderbook();
            Long contractId = oldOrderbook.getContractId();
            Optional<Orderbook> orderbookOptional = area == null ? this.orderbookQueries.findByContractIdAndDeliveryAreaId(contractId, oldOrderbook.getDeliveryAreaId()) : this.orderbookQueries.findByContractIdAndDeliveryAreaId(contractId, area.getId());
            orderbookOptional.ifPresent(orderbookWrapper::setOrderbook);
        }
        this.refilterOrderbooks();
    }

    protected void refilterOrderbooks() {
        this.filteredOrderbooks.setPredicate(this::shouldBeDisplayed);
    }

    @Override
    public void addContracts(List<Contract> contracts, ContractRestriction restriction, ContractAdditionOrigin origin) {
        DeliveryArea selectedDeliveryArea = (DeliveryArea)this.deliveryAreaChoiceBox.getValue();
        ArrayList<Orderbook> toAdd = Lists.newArrayList();
        for (Contract contract : this.filterContractsToAdd(contracts)) {
            Optional<Orderbook> orderbook2add = this.getOrderbook(contract, selectedDeliveryArea);
            if (orderbook2add.isPresent()) {
                toAdd.add(orderbook2add.get());
                continue;
            }
            LOG.debug("No preferred delivery area found for the contract: {}", (Object)contract);
        }
        this.addOrderbooks(toAdd, restriction, origin);
    }

    private Optional<Orderbook> getOrderbook(Contract contract, DeliveryArea selectedDeliveryArea) {
        Optional<Object> orderbook2add = Optional.empty();
        if (selectedDeliveryArea != null && !this.isOrderbookPresentAndDAStatusIsVisible(orderbook2add = this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)selectedDeliveryArea.getId()), selectedDeliveryArea)) {
            orderbook2add = Optional.empty();
        }
        if (!orderbook2add.isPresent() && this.userService.getCurrentUserRoles() != null && this.userService.getCurrentUserRoles().isAdmin()) {
            orderbook2add = this.orderbookQueries.findByContract(contract).stream().findFirst();
        }
        DeliveryArea userDefaultDeliveryArea = this.orderPreferencesService.getDefaultDeliveryArea();
        if (!orderbook2add.isPresent() && userDefaultDeliveryArea != null && !this.isOrderbookPresentAndDAStatusIsVisible(orderbook2add = this.orderbookQueries.findByContractIdAndDeliveryAreaId((Long)contract.getId(), (String)userDefaultDeliveryArea.getId()), userDefaultDeliveryArea)) {
            orderbook2add = Optional.empty();
        }
        if (!orderbook2add.isPresent()) {
            orderbook2add = this.orderbookQueries.findByContract(contract).stream().filter(o -> o.getContract().getCompoundStatus().getDeliveryAreaStatusOrInactive(o.getDeliveryArea()).isVisible() && this.assignmentService.isDeliveryAreaAssignedToUser(this.userService.getCurrentUser(), o.getDeliveryArea())).findFirst();
        }
        return orderbook2add;
    }

    private boolean isOrderbookPresentAndDAStatusIsVisible(Optional<Orderbook> orderbook, DeliveryArea deliveryArea) {
        return orderbook.isPresent() && orderbook.get().getContract().getCompoundStatus().getDeliveryAreaStatusOrInactive(deliveryArea).isVisible();
    }

    protected List<Contract> filterContractsToAdd(List<Contract> contracts) {
        return contracts.stream().filter(Objects::nonNull).filter(this.contractTreeContext.getContractFilter()).toList();
    }

    public void minimizeContractPanel() {
        this.contractTreePane.hideContractTree();
    }

    private boolean addDroppedContent(Dragboard db) {
        if (!this.dragAndDropService.hasContractList(db) && !this.dragAndDropService.hasProductList(db)) {
            return false;
        }
        if (this.dragAndDropService.hasProductList(db)) {
            for (Product product : this.dragAndDropService.getProductList(db)) {
                this.contractTreeContext.productSubscribed(product);
            }
        }
        if (this.dragAndDropService.hasContractList(db)) {
            this.addContracts(this.dragAndDropService.getContractList(db), ContractRestriction.UNRESTRAINED, ContractAdditionOrigin.MANUAL);
        }
        return true;
    }

    protected DragAndDropService getDragAndDropService() {
        return this.dragAndDropService;
    }

    protected void addOrderbooks(List<Orderbook> orderbooks, ContractRestriction restriction, ContractAdditionOrigin origin) {
        if (orderbooks != null && !orderbooks.isEmpty()) {
            this.addNewOrderbookItems(orderbooks, restriction, origin);
            if (this.deliveryAreaChoiceBox.getValue() != null) {
                this.filterOrderBooks((BroadcastEntity)this.deliveryAreaChoiceBox.getValue());
            } else {
                this.refilterOrderbooks();
            }
        }
    }

    private void addNewOrderbookItems(List<Orderbook> toAdd, ContractRestriction restriction, ContractAdditionOrigin origin) {
        try {
            this.orderbooksBeingAdded.incrementAndGet();
            Stream<Object> orderbooksStream = toAdd.stream();
            if (restriction == ContractRestriction.EACH_CONTRACT_ONLY_ONCE) {
                orderbooksStream = orderbooksStream.filter(newOrderbook -> this.orderbooks.stream().noneMatch(currentOrderbook -> newOrderbook.getContract().equals(currentOrderbook.getOrderbook().getContract())));
            }
            List<OrderbookValueWrapper> widgetsToAdd = orderbooksStream.map(orderbook -> this.getOrderbookItem((Orderbook)orderbook, this, origin)).toList();
            FxUtil.runInFxThread(() -> {
                try {
                    if (restriction == ContractRestriction.EACH_CONTRACT_ONLY_ONCE) {
                        widgetsToAdd.stream().filter(newOrderbook -> this.orderbooks.stream().noneMatch(currentOrderbook -> newOrderbook.getOrderbook().getContract().equals(currentOrderbook.getOrderbook().getContract()))).forEach(this.orderbooks::add);
                    } else {
                        this.orderbooks.addAll((Collection<O>)widgetsToAdd);
                    }
                }
                finally {
                    this.orderbooksBeingAdded.decrementAndGet();
                }
            });
        }
        catch (Exception e) {
            this.orderbooksBeingAdded.decrementAndGet();
            LOG.error("Error while adding orderbook.", e);
        }
    }

    private boolean shouldBeDisplayed(OrderbookValueWrapper orderbookWrapper) {
        List<ContractStatus> contractStatus;
        Orderbook orderbook = orderbookWrapper.getOrderbook();
        if (orderbook == null || this.backendConnectionGateway.getSession() == null || orderbook.getContractStatus().isInactive()) {
            return false;
        }
        Contract contract = orderbook.getContract();
        BroadcastEntity area = (BroadcastEntity)this.deliveryAreaChoiceBox.getValue();
        if (area instanceof DeliveryArea && !area.equals(orderbook.getDeliveryArea()) || area instanceof MarketArea && !area.equals(orderbook.getDeliveryArea().getMarketArea())) {
            return false;
        }
        if (area instanceof DeliveryArea && !orderbook.getContract().getCompoundStatus().getDeliveryAreaStatusOrInactive(orderbook.getDeliveryArea()).isVisible()) {
            return false;
        }
        DeliveryDateFilterChoice deliveryDateFilter = (DeliveryDateFilterChoice)this.deliveryDateFilterChoiceBox.getValue();
        DateTimeZone contractTimeZone = contract.getProduct() != null ? DateTimeZone.forID(contract.getProduct().getTimeZone()) : contract.getExchange().getSystemInfo().getTimeZone();
        DateTime serverTime = this.getAppContext().getService(TimeService.class).getServerTime().withZone(contractTimeZone);
        DateTime displayStartTime = deliveryDateFilter.getStartTime(serverTime);
        DateTime displayEndTime = deliveryDateFilter.getEndTime(serverTime);
        if (contract.getDeliveryStart() != null && this.getBottomToolbar().getToolbarItems().contains(this.deliveryDateFilterChoiceBox) && (contract.getDeliveryStart().isAfter(displayEndTime) || contract.getDeliveryStart().isBefore(displayStartTime))) {
            return false;
        }
        List<ContractStatus> list = contractStatus = this.contractStatusFilterChoiceBox != null ? this.contractStatusFilterChoiceBox.getSelectedContractStatuses() : null;
        return contractStatus == null || !this.getBottomToolbar().getToolbarItems().contains(this.contractStatusFilterChoiceBox) || contractStatus.contains(orderbook.getContractStatus());
    }

    public abstract O getOrderbookItem(Orderbook var1, OrderbookRemovalCallback var2, ContractAdditionOrigin var3);

    protected OrderbookPanelState getBasicState() {
        BroadcastEntity selectedArea = (BroadcastEntity)this.deliveryAreaChoiceBox.getValue();
        List<PersistentOrderbookId> orderbookIds = this.orderbooks.stream().filter(o -> o.getOrigin() == ContractAdditionOrigin.MANUAL).map(OrderbookValueWrapper::getOrderbook).filter(Objects::nonNull).map(Orderbook::getPersistentOrderbookId).toList();
        List<String> productIds = this.contractTreeContext.getSubscribedProducts().stream().map(BroadcastEntity::getId).toList();
        String areaId = selectedArea != null ? (String)selectedArea.getId() : null;
        return new OrderbookPanelState((DeliveryDateFilterChoice)this.deliveryDateFilterChoiceBox.getValue(), (Integer)this.limitChoiceBox.getValue(), this.bottomToolbar.getState(), orderbookIds, productIds, areaId);
    }

    protected void restoreComponentState(OrderbookPanelState componentState) {
        this.deliveryDateFilterChoiceBox.setValue(componentState.getDeliveryDateFilterChoice());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        if (this.limitChoiceBox.getItems().contains(componentState.getOrderbookDepth())) {
            this.limitChoiceBox.setValue(componentState.getOrderbookDepth());
        }
        this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
        if (componentState.getDeliveryAreaEntityId() != null) {
            this.deliveryAreaChoiceBox.setValueFromId(componentState.getDeliveryAreaEntityId());
        }
        for (PersistentOrderbookId persistentOrderbookId : componentState.getOrderbookIds()) {
            Optional<Orderbook> orderbook = this.orderbookQueries.findByPersistentOrderbookId(persistentOrderbookId);
            if (!orderbook.isPresent() || !ContractFilters.NOT_INACTIVE.test(orderbook.get().getContract()) || !ProductFilters.ONLY_ACTIVE.test(orderbook.get().getContract().getProduct())) continue;
            this.restoreAddOrderbook(orderbook.get());
        }
        SmallFastDataModel<String, Product> productDataModel = this.getAppContext().getSmallDataModel(Product.class);
        for (String productId : componentState.getProductIds()) {
            Product product = (Product)productDataModel.findById(productId);
            if (product == null || !ProductFilters.ONLY_ACTIVE.test(product)) continue;
            this.contractTreeContext.productSubscribed(product);
        }
    }

    protected void restoreAddOrderbook(Orderbook orderbook) {
        this.addOrderbooks(Lists.newArrayList(orderbook), ContractRestriction.UNRESTRAINED, ContractAdditionOrigin.MANUAL);
    }

    @Subscribe
    public void handleMidnightEvent(FullHourEvent event) {
        if (event.getHour() == 0) {
            this.refilterOrderbooks();
        }
    }

    @Override
    public void highlightContractDAs(List<AlertingRecord> contractDeliveryAreas) {
        FxUtil.runInFxThread(() -> {
            for (OrderbookValueWrapper orderbookWrapper : this.orderbooks) {
                AlertingRecord alertingRecord = null;
                for (AlertingRecord record : contractDeliveryAreas) {
                    if (!record.getContractId().equals(orderbookWrapper.getOrderbook().getContractId()) || !record.getDeliveryAreaId().equals(orderbookWrapper.getOrderbook().getDeliveryAreaId())) continue;
                    alertingRecord = new AlertingRecord(record);
                    break;
                }
                orderbookWrapper.setAlertingInfo(alertingRecord);
            }
        });
    }

    protected AbstractAreaChoiceBox<A> getAreaChoiceBox() {
        return this.deliveryAreaChoiceBox;
    }

    protected Node getEmptyOrderbookPanelPlaceholder() {
        return this.emptyOrderbookPanelPlaceholder;
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }

    public void setBottomToolbar(BottomToolbar bottomToolbar) {
        this.bottomToolbar = bottomToolbar;
    }

    public ContractTree getContractTree() {
        return this.contractTreePane.getContractTree();
    }
}

