/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DetailedOrderbookPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTables;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.event.CombinationsChangedEvent;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.google.common.eventbus.Subscribe;

@DraggableComponent(hasPublicAccess=true, nameKey="extendedOrderbookPanel_header_label", descriptionKey="extendedOrderbookPanel_description")
@PanelWithLoadingIndicator(entityClasses={Orderbook.class})
@OverrideGuiConfiguration(field="bottomToolbar", overrideId="ExtendedOrderbookPanel", strategy=BottomToolbarOverrideGuiStrategy.class)
public class ExtendedOrderbookPanel
extends DetailedOrderbookPanel {
    public ExtendedOrderbookPanel() {
        super(FXMLLoaderWithContext.getAppContext(), ContractFilters.ONLY_CANONICAL_CONTRACTS_FILTER);
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    @Override
    public DetailedOrderbookPanel.ExtendedOrderbook getOrderbookItem(Orderbook orderbook, OrderbookRemovalCallback orderbookRemovalCallback, ContractAdditionOrigin origin) {
        CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack = new CloseRemoveOrderbookCallBack(){

            @Override
            public void closeOrderbookPane(AbstractOrderbookPane abstractOrderbookPane) {
                ExtendedOrderbookPanel.this.closeExtendedOrderbookPane(abstractOrderbookPane);
            }

            @Override
            public void removeOrHideOrderbook(Orderbook orderbook) {
                ExtendedOrderbookPanel.this.removeOrHideOrderbook(orderbook);
            }
        };
        ExtendedOrderbookPane extendedOrderbookPane = new ExtendedOrderbookPane(this.getAppContext(), orderbook, closeRemoveOrderbookCallBack, new WeakObservableValue<Integer>(this.limitChoiceBox.valueProperty()), this.getAreaChoiceBox(), true);
        return new DetailedOrderbookPanel.ExtendedOrderbook(extendedOrderbookPane, orderbookRemovalCallback, origin);
    }

    @Subscribe
    public void handleCombinationChanged(CombinationsChangedEvent event) {
        this.orderbooks.stream().filter(extendedOrderbook -> event.getAffectedOrderbook().equals(extendedOrderbook.getOrderbook())).map(DetailedOrderbookPanel.ExtendedOrderbook::getOrderbookPane).map(AbstractOrderbookPane::getEntryTables).forEach(ExtendedOrderbookTables::reloadOrderbookEntries);
    }
}

