/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractOrderPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.TotalsCounter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.OrderFilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrderPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrdersCanBeActivatedBinding;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrdersCanBeDeactivatedBinding;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrdersCanBeModified;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javax.annotation.Nullable;

@DraggableComponent(hasPublicAccess=true, nameKey="ownOrderPanel_header_label", descriptionKey="ownOrderPanel_description")
@PanelWithLoadingIndicator(entityClasses={Order.class})
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="tableView", overrideId="OwnOrderPanel", strategy=TableViewOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="bottomToolbar", overrideId="OwnOrderPanel", strategy=BottomToolbarOverrideGuiStrategy.class)})
public class OwnOrderPanel
extends AbstractOrderPanel {
    private OrderFilteredTableView filteredTableView;
    @FXML
    private Button deactAllButton;
    @FXML
    private Button deactivateButton;
    @FXML
    private Button activateButton;
    @FXML
    private Button modifyButton;
    @FXML
    private Button deleteButton;
    @FXML
    private FilterPopupButton<Order> filterButton;
    @FXML
    private TotalsCounter totalsCounter;
    public final AllEntitiesProvider<Long, Order> orderAllEntitiesProvider = new AllEntitiesProvider(this.getAppContext().getSmallDataModel(Order.class));

    public OwnOrderPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OwnOrderPanel(ApplicationContext appContext) {
        super(appContext);
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.filteredTableView = new OrderFilteredTableView(this.orderTableView, new IsOwnOrderPredicate(this.getAppContext().getService(OwnQuantityLookupService.class)), this.orderAllEntitiesProvider);
        this.orderTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.deleteButton.disableProperty().bind(Bindings.isEmpty(this.orderTableView.getSelectionModel().getSelectedIndices()));
        this.activateButton.disableProperty().bind(new OrdersCanBeActivatedBinding(this.orderTableView.getSelectionModel(), this.getAppContext().getService(OrderValidationService.class)).not());
        this.deactivateButton.disableProperty().bind(new OrdersCanBeDeactivatedBinding(this.orderTableView.getSelectionModel(), this.getAppContext().getService(OrderValidationService.class)).not());
        this.modifyButton.disableProperty().bind(new OrdersCanBeModified(this.orderTableView.getSelectionModel()).not());
        this.deactAllButton.disableProperty().bind(this.filteredTableView.anyActiveOrderProperty().not());
        this.filterButton.initialize(this.filteredTableView);
        this.totalsCounter.totalItemsProperty().bind(this.filteredTableView.totalItems());
        this.totalsCounter.shownItemsProperty().bind(this.filteredTableView.shownItems());
    }

    @Override
    protected void userChanged() {
        this.filteredTableView.setBaseFilter(this.createNewBaseFilter());
    }

    private IsOwnOrderPredicate createNewBaseFilter() {
        return new IsOwnOrderPredicate(this.getAppContext().getService(OwnQuantityLookupService.class));
    }

    @FXML
    public void deactivateAllOrderButtonClickAction() {
        String questionText = Util.getLabel("emergencyService_deactivateAll_question");
        String questionHeader = Util.getLabel("commons_deactivateAllQuestion");
        if (this.getAppContext().getService(UserAlertService.class).showQuestionDialog(questionHeader, questionText, UserAlertService.Flag.OK_CANCEL)) {
            this.deactivateAllOrder();
        }
        this.orderTableView.getSelectionModel().clearSelection();
    }

    @FXML
    public void modifySelectedOrderButtonClickAction() {
        ObservableList orders = this.orderTableView.getSelectionModel().getSelectedItems();
        if (orders.isEmpty()) {
            return;
        }
        Order order = (Order)orders.iterator().next();
        this.orderTableView.getSelectionModel().clearSelection();
        this.getAppContext().getService(OrderPopup.class).showExtendedOrderPopup(order, false, this.modifyButton);
        this.orderTableView.getSelectionModel().clearSelection();
    }

    @Override
    public OrderPanelState getComponentState() {
        return new OrderPanelState(StorableTableLayoutDescriptor.fromTable(this.orderTableView), this.menu.isExpanded(), this.bottomToolbar.getState(), this.filteredTableView.getCustomFilter().getFilterStates());
    }

    @Override
    public void restoreComponentState(OrderPanelState componentState) {
        super.restoreComponentState(componentState);
        this.filteredTableView.loadCustomFilter(componentState.getColumnFilters());
    }

    protected static class IsOwnOrderPredicate
    implements Predicate<Order> {
        private final OwnQuantityLookupService ownQuantityLookupService;

        public IsOwnOrderPredicate(OwnQuantityLookupService ownQuantityLookupService) {
            this.ownQuantityLookupService = ownQuantityLookupService;
        }

        @Override
        public boolean test(@Nullable Order order) {
            if (order == null) {
                return false;
            }
            if (order.getOrderType() == OrderType.OTC_PREARRANGED) {
                return false;
            }
            return this.ownQuantityLookupService.isOwnOrder(order);
        }
    }
}

