/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.DateTimeAxisFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryDateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DeliveryAreaBottomToolbarChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.EmptyFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.ContractGanttChartBarFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.GanttChart;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.OrderbookLabeledBar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.ProductListView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.ProductTimeLineState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.ProductTimelineContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SlideInContractTreePane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.base.AbstractInstant;

@DraggableComponent(hasPublicAccess=true, nameKey="productTimelinePanel_header_label", descriptionKey="productTimelinePanel_description")
@PanelWithLoadingIndicator(entityClasses={Product.class})
@OverrideGuiConfiguration(field="bottomToolbar", overrideId="ProductTimeLinePanel", strategy=BottomToolbarOverrideGuiStrategy.class)
public class ProductTimeLinePanel
extends AbstractPanel
implements StorableComponent<ProductTimeLineState>,
ProductListView {
    @FXML
    protected GanttChart<Contract, OrderbookLabeledBar> chart;
    @FXML
    protected DeliveryAreaBottomToolbarChoiceBox deliveryAreaChoiceBox;
    @FXML
    protected BottomToolbar bottomToolbar;
    @FXML
    protected BottomToolbarButton navigateLeftButton;
    @FXML
    protected BottomToolbarButton navigateRightButton;
    private static final int UPDATE_INTERVAL = 2000;
    private final ScheduledFuture<?> updateTimer;
    private final SlideInContractTreePane productTreePane;
    private final XYChart.Series<Number, String> productSeries = new XYChart.Series();
    private final AllEntitiesProvider<Long, Contract> allContractsEntitiesProvider;
    private final AbstractDataModelListener<Contract> dataModelListener;
    private ContractQueries contractQueries;
    private SimpleObjectProperty<DateTimeZone> timeZone;
    private final ObjectProperty<Long> lowerBound = new SimpleObjectProperty<Long>();
    private final ObjectProperty<Long> upperBound = new SimpleObjectProperty<Long>();
    private final ProductTimelineContractTreeContext productTreeContext = new ProductTimelineContractTreeContext(c -> false, new EmptyFilter<Product>(), this);
    private double offsetX = 0.0;
    private ScheduledFuture<?> navigationTask;

    public ProductTimeLinePanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ProductTimeLinePanel(ApplicationContext appContext) {
        super(appContext);
        this.productTreePane = new SlideInContractTreePane(appContext, this.productTreeContext);
        this.allContractsEntitiesProvider = new AllEntitiesProvider(this.getAppContext().getSmallDataModel(Contract.class));
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.dataModelListener = new AbstractDataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Contract c) {
                if (ProductTimeLinePanel.this.productTreeContext.isSubscribed(c.getProduct())) {
                    ProductTimeLinePanel.this.productSeries.getData().add(new XYChart.Data<Long, String>(c.getDeliveryStart().getMillis(), c.getProduct().getDisplayName(), c));
                }
                return super.notifyUpdate(c);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Contract object) {
                List<XYChart.Data> removeList = ProductTimeLinePanel.this.productSeries.getData().stream().filter(numberStringData -> ((String)numberStringData.getYValue()).equals(object.getProduct().getDisplayName())).toList();
                ProductTimeLinePanel.this.productSeries.getData().removeAll((Collection<?>)removeList);
                return super.notifyRemove(object);
            }
        };
        this.allContractsEntitiesProvider.getRelevantEntities().forEach(this.dataModelListener::notifyAdd);
        this.allContractsEntitiesProvider.registerDataModelListener(this.dataModelListener);
        this.updateTimer = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class).scheduleAtFixedRate(FxUtil.wrapWithRunInFxThread(this::updateTime), 0L, 2000L, TimeUnit.MILLISECONDS);
        this.lowerBound.addListener(o -> this.updateTime());
        this.upperBound.addListener(o -> this.updateTime());
        this.loadFxml();
    }

    @Override
    public void initialize() {
        DateTimeAxisFactory dateTimeAxisFactory = new DateTimeAxisFactory();
        this.timeZone = new SimpleObjectProperty<DateTimeZone>(DateTimeZone.UTC);
        NumberAxis priceXAxis = dateTimeAxisFactory.createDateTimeAxis(this.timeZone, false, true, 3600000, 3600000, 4);
        priceXAxis.lowerBoundProperty().bind(this.lowerBound);
        priceXAxis.upperBoundProperty().bind(this.upperBound);
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setAnimated(false);
        this.chart = new GanttChart(priceXAxis, categoryAxis);
        this.chart.setCellFactory(new ContractGanttChartBarFactory(this.getAppContext(), this.deliveryAreaChoiceBox.valueProperty()));
        this.chart.getData().addAll(this.productSeries);
        this.chart.setOnScroll(event -> {
            if (event.getDeltaY() != 0.0) {
                this.lowerBound.set((Long)this.lowerBound.get() + (long)(3600000 * (event.getDeltaY() > 0.0 ? -1 : 1)));
                this.upperBound.set((Long)this.upperBound.get() - (long)(3600000 * (event.getDeltaY() > 0.0 ? -1 : 1)));
            }
            if (event.getDeltaX() != 0.0) {
                this.lowerBound.set((Long)this.lowerBound.get() + (long)(3600000 * (event.getDeltaX() > 0.0 ? -1 : 1)));
                this.upperBound.set((Long)this.upperBound.get() + (long)(3600000 * (event.getDeltaX() > 0.0 ? -1 : 1)));
            }
        });
        FontService service = this.getAppContext().getService(FontService.class);
        this.chart.setBlockHeight(service.getFontSize().getFontSize() + 6.0);
        this.setCenter(this.chart);
        this.setLeft(this.productTreePane);
        this.chart.widthProperty().addListener(o -> this.updateTime());
        this.recalculateBounds(DeliveryDateFilterChoice.BOTH);
        this.navigateLeftButton.setOnMousePressed(event -> {
            this.navigationTask = this.getAppContext().getService(ScheduledExecutorService.class, WorkerExecutor.class).scheduleAtFixedRate(() -> this.navigateLeft(), 0L, 200L, TimeUnit.MILLISECONDS);
        });
        this.navigateRightButton.setOnMousePressed(event -> {
            this.navigationTask = this.getAppContext().getService(ScheduledExecutorService.class, WorkerExecutor.class).scheduleAtFixedRate(() -> this.navigateRight(), 0L, 200L, TimeUnit.MILLISECONDS);
        });
        this.navigateLeftButton.setOnMouseReleased(event -> {
            if (this.navigationTask != null) {
                this.navigationTask.cancel(true);
            }
        });
        this.navigateRightButton.setOnMouseReleased(event -> {
            if (this.navigationTask != null) {
                this.navigationTask.cancel(true);
            }
        });
    }

    private void updateTime() {
        this.chart.currentTimeProperty().set(this.getAppContext().getService(TimeService.class).getServerTime());
    }

    @Override
    public void destroy() {
        super.destroy();
        this.updateTimer.cancel(true);
    }

    @FXML
    public void showAll(ActionEvent actionEvent) {
        this.recalculateBounds(DeliveryDateFilterChoice.BOTH);
    }

    @FXML
    public void showToday(ActionEvent actionEvent) {
        this.recalculateBounds(DeliveryDateFilterChoice.TODAY);
    }

    public void navigateLeft() {
        this.lowerBound.set((Long)this.lowerBound.get() - 3600000L);
        this.upperBound.set((Long)this.upperBound.get() - 3600000L);
    }

    public void navigateRight() {
        this.lowerBound.set((Long)this.lowerBound.get() + 3600000L);
        this.upperBound.set((Long)this.upperBound.get() + 3600000L);
    }

    @FXML
    public void zoomIn(ActionEvent actionEvent) {
        long zoomDistance = ((Long)this.upperBound.get() - (Long)this.lowerBound.get()) / 4L;
        zoomDistance -= zoomDistance % 3600000L;
        this.lowerBound.set((Long)this.lowerBound.get() + zoomDistance);
        this.upperBound.set((Long)this.upperBound.get() - zoomDistance);
    }

    @FXML
    public void zoomOut(ActionEvent actionEvent) {
        long zoomDistance = ((Long)this.upperBound.get() - (Long)this.lowerBound.get()) / 4L;
        zoomDistance += 3600000L - zoomDistance % 3600000L;
        this.lowerBound.set((Long)this.lowerBound.get() - zoomDistance);
        this.upperBound.set((Long)this.upperBound.get() + zoomDistance);
    }

    public void recalculateBounds(DeliveryDateFilterChoice deliveryDateValue) {
        ObservableObjectValue<Exchange> activeExchange = this.getAppContext().getService(ActiveExchange.class).getActiveExchange();
        if (activeExchange.get() != null) {
            this.timeZone.set(activeExchange.get().getSystemInfo().getTimeZone());
        }
        DateTime serverTime = this.getAppContext().getService(TimeService.class).getServerTime();
        if (deliveryDateValue == DeliveryDateFilterChoice.BOTH) {
            this.allContractsEntitiesProvider.getRelevantEntities().map(Contract::getDeliveryStart).min(AbstractInstant::compareTo).ifPresent(e -> this.lowerBound.set(e.getMillis()));
            this.allContractsEntitiesProvider.getRelevantEntities().map(Contract::getDeliveryEnd).max(AbstractInstant::compareTo).ifPresent(e -> this.upperBound.set(e.getMillis()));
        } else {
            this.lowerBound.set(deliveryDateValue.getStartTime(serverTime).getMillis());
            this.upperBound.set(deliveryDateValue.getEndTime(serverTime).getMillis());
        }
        this.updateTime();
    }

    @Override
    public ProductTimeLineState getComponentState() {
        List<String> productIds = this.productTreeContext.getSubscribedProducts().stream().map(BroadcastEntity::getId).toList();
        return new ProductTimeLineState(this.bottomToolbar.getState(), (String)((DeliveryArea)this.deliveryAreaChoiceBox.getValue()).getId(), productIds);
    }

    @Override
    public void restoreComponentState(ProductTimeLineState componentState) {
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        SmallFastDataModel<String, Product> productDataModel = this.getAppContext().getSmallDataModel(Product.class);
        for (String productId : componentState.getProductIds()) {
            Product product = (Product)productDataModel.findById(productId);
            if (product == null) continue;
            this.productTreeContext.productSubscribed(product);
        }
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }

    @Override
    public void addProduct(Product product) {
        this.contractQueries.findByProduct(product).getAll().forEach(this.dataModelListener::notifyAdd);
    }

    @Override
    public void removeProduct(Product product) {
        this.contractQueries.findByProduct(product).getAll().forEach(this.dataModelListener::notifyRemove);
    }
}

