/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.TradingLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TradingLimitAwareShowLoadingIndicatorRule;
import com.deutscheboerse.comxerv.comtrader.jfx.components.limit.TradingLimitPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TableUpdateManager;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;

@DraggableComponent(hasPublicAccess=true, nameKey="tradingLimitPanel_header_label", descriptionKey="tradingLimitPanel_description")
@PanelWithLoadingIndicator(entityClasses={TradingLimit.class}, showLoadingIndicatorRule=TradingLimitAwareShowLoadingIndicatorRule.class)
public class TradingLimitPanel
extends AbstractPanel
implements StorableComponent<TradingLimitPanelState> {
    private final TableUpdateManager tableUpdateManager = this.getAppContext().getService(TableUpdateManager.class);
    private final UserService userService = this.getAppContext().getService(UserService.class);
    private final ObservableValue<User> currentUser;
    private final TradingLimitQueries tradingLimitQueries = this.getAppContext().getService(TradingLimitQueries.class);
    private final DataModelListener<TradingLimit> tradingLimitDataModelListener;
    private final InvalidationListener userChange;
    @FXML
    private CustomTableView<TradingLimit> tradingLimitTableView;

    public TradingLimitPanel() {
        super(FXMLLoaderWithContext.getAppContext());
        this.currentUser = this.userService.currentUserProperty();
        this.userChange = observable2 -> this.refreshList();
        this.currentUser.addListener(new WeakInvalidationListener(this.userChange));
        this.tradingLimitDataModelListener = new AbstractDataModelListener<TradingLimit>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(TradingLimit tradingLimit) {
                if (!TradingLimitPanel.this.tradingLimitTableView.getItems().contains(tradingLimit) && TradingLimitPanel.this.inScope(tradingLimit)) {
                    TradingLimitPanel.this.tradingLimitTableView.getItems().add(tradingLimit);
                    TradingLimitPanel.this.tableUpdateManager.submitSortRequest(TradingLimitPanel.this.tradingLimitTableView);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(TradingLimit object) {
                TradingLimitPanel.this.tradingLimitTableView.getItems().remove(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                TradingLimitPanel.this.tradingLimitTableView.getItems().clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(TradingLimit object) {
                TradingLimitPanel.this.tableUpdateManager.submitSortRequest(TradingLimitPanel.this.tradingLimitTableView);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getAppContext().getSmallDataModel(TradingLimit.class).registerListener(new WeakDataModelListener<TradingLimit>(this.tradingLimitDataModelListener));
        this.tradingLimitTableView.setRowFactory(tableView -> {
            TableRow<MouseEvent> row = new TableRow<MouseEvent>();
            row.addEventFilter(MouseEvent.MOUSE_PRESSED, new DeselectionEventHandler(row));
            return row;
        });
    }

    private void refreshList() {
        this.tradingLimitTableView.getItems().clear();
        User user = this.currentUser.getValue();
        if (user != null) {
            this.tradingLimitQueries.findByMemberId(user.getMemberId()).getAll().forEach(this.tradingLimitTableView.getItems()::add);
        }
        this.tableUpdateManager.submitSortRequest(this.tradingLimitTableView);
    }

    private boolean inScope(TradingLimit tradingLimit) {
        String currentMemberId = this.userService.getCurrentUser().getMemberId();
        return tradingLimit.getMemberId().equals(currentMemberId);
    }

    @Override
    public TradingLimitPanelState getComponentState() {
        return new TradingLimitPanelState(StorableTableLayoutDescriptor.fromTable(this.tradingLimitTableView));
    }

    @Override
    public void restoreComponentState(TradingLimitPanelState componentState) {
        componentState.getTradingLimitTableDescriptor().applyToTable(this.tradingLimitTableView);
    }
}

