/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;

public class BarXYChart
extends XYChart<Number, Number> {
    private static final int DISPLAY_POSITION_NULL = 0;
    private static final Color DEFAULT_COLOR = Color.RED;
    private static final double LAYOUT_X_GAP = 0.5;

    public BarXYChart(Axis<Number> xAxis, Axis<Number> yAxis) {
        super(xAxis, yAxis);
        this.setAnimated(false);
        xAxis.setAnimated(false);
        yAxis.setAnimated(false);
    }

    @Override
    protected void layoutPlotChildren() {
        if (this.getData() == null) {
            return;
        }
        for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator it = this.getDisplayedDataIterator(series);
            while (it.hasNext()) {
                XYChart.Data item = it.next();
                double x = this.getXAxis().getDisplayPosition((Number)this.getCurrentDisplayedXValue(item));
                double y = this.getYAxis().getDisplayPosition((Number)this.getCurrentDisplayedYValue(item));
                Node itemNode = item.getNode();
                if (!(itemNode instanceof QtyLine)) continue;
                QtyLine qtyLine = (QtyLine)itemNode;
                double high = this.getYAxis().getDisplayPosition((Number)item.getYValue());
                double low = this.getYAxis().getDisplayPosition(0);
                qtyLine.update(high - y, low - y);
                qtyLine.setLayoutX(x + 0.5);
                qtyLine.setLayoutY(y);
            }
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<Number, Number> item) {
    }

    @Override
    protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
        Node qtyLine = this.createQtyLine(item);
        this.show(qtyLine);
        if (series.getNode() != null) {
            series.getNode().toFront();
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<Number, Number> item, XYChart.Series<Number, Number> series) {
        Node qtyLine = item.getNode();
        this.hide(qtyLine);
    }

    private void hide(Node node) {
        this.getPlotChildren().remove(node);
    }

    @Override
    protected void seriesAdded(XYChart.Series<Number, Number> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node qtyLine = this.createQtyLine(item);
            this.show(qtyLine);
        }
    }

    private void show(Node node) {
        this.getPlotChildren().add(node);
    }

    @Override
    protected void seriesRemoved(XYChart.Series<Number, Number> series) {
        series.getData().stream().map(XYChart.Data::getNode).forEach(this::hide);
    }

    private Node createQtyLine(XYChart.Data item) {
        QtyLine qtyLine = new QtyLine();
        item.setNode(qtyLine);
        return qtyLine;
    }

    @Override
    protected void updateAxisRange() {
        this.invalidateRange(this.getXAxis(), XYChart.Data::getXValue);
        this.invalidateRange(this.getYAxis(), XYChart.Data::getYValue);
    }

    private void invalidateRange(Axis<Number> axis, Function<XYChart.Data<Number, Number>, Number> dataProperty) {
        if (axis.isAutoRanging()) {
            List<Number> yData = this.getData().stream().flatMap(series -> series.getData().stream()).map(dataProperty).toList();
            this.getYAxis().invalidateRange(yData);
        }
    }

    private static final class QtyLine
    extends Group {
        private static final double STROKE_WIDTH = 3.0;
        private Line line = new Line();

        private QtyLine() {
            this.setAutoSizeChildren(false);
            this.line.setStrokeWidth(3.0);
            this.line.setStroke(DEFAULT_COLOR);
            this.getChildren().addAll((Node[])new Node[]{this.line});
        }

        public void update(double highY, double lowY) {
            this.line.setStartY(highY);
            this.line.setEndY(lowY);
        }
    }
}

