/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import javafx.util.StringConverter;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeAxisFactory {
    public NumberAxis createDateTimeAxis(ObservableValue<DateTimeZone> timeZone, boolean showLabels) {
        NumberAxis dateTimeAxis = new NumberAxis(showLabels ? Util.getLabel("commons_timeChart") : null, 0.0, Double.MAX_VALUE, 1.0);
        dateTimeAxis.setTickLabelFormatter(new DateTimeLabelFormatter(timeZone));
        dateTimeAxis.setForceZeroInRange(false);
        dateTimeAxis.setAutoRanging(false);
        dateTimeAxis.setTickUnit(300000.0);
        dateTimeAxis.setMinorTickCount(5);
        dateTimeAxis.setTickLabelsVisible(showLabels);
        dateTimeAxis.setAnimated(false);
        return dateTimeAxis;
    }

    public NumberAxis createDateTimeAxis(ObservableValue<DateTimeZone> timeZone, boolean showLabels, boolean tickLabelsVisible, int tickUnit, int tickLength, int minorTickCount) {
        NumberAxis dateTimeAxis = this.createDateTimeAxis(timeZone, showLabels);
        dateTimeAxis.setTickUnit(tickUnit);
        dateTimeAxis.setTickLength(tickLength);
        dateTimeAxis.setMinorTickCount(minorTickCount);
        dateTimeAxis.setTickLabelsVisible(tickLabelsVisible);
        return dateTimeAxis;
    }

    private static class DateTimeLabelFormatter
    extends StringConverter<Number> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("HH:mm");
        private final DependentBinding<DateTimeFormatter> formatterWithTimeZone;

        public DateTimeLabelFormatter(ObservableValue<DateTimeZone> timeZone) {
            this.formatterWithTimeZone = DependentBinding.get(FORMATTER::withZone, timeZone, FORMATTER);
        }

        @Override
        public String toString(Number object) {
            return " " + ((DateTimeFormatter)this.formatterWithTimeZone.get()).print(object.longValue()) + " ";
        }

        @Override
        public Number fromString(String string) {
            return ((DateTimeFormatter)this.formatterWithTimeZone.get()).parseDateTime(string).getMillis();
        }
    }
}

