/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;

public class DeliveryAreaChoiceBox
extends AbstractAreaChoiceBox<DeliveryArea> {
    private final ObjectProperty<Contract> contract = new SimpleObjectProperty<Contract>();
    private final ObjectProperty<BalancingGroup> balancingGroup;
    private final ValidProperty validProperty;
    private final ChangeListener<Contract> contractChangeListener = (observable2, oldValue, newValue) -> this.recomputeListedItems();
    private final WeakChangeListener<Contract> weakContractChangeListener = new WeakChangeListener<Contract>(this.contractChangeListener);
    private boolean validation;

    public DeliveryAreaChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DeliveryAreaChoiceBox(ApplicationContext appContext) {
        super(appContext, DeliveryArea.class);
        this.contract.addListener(this.weakContractChangeListener);
        this.balancingGroup = new SimpleObjectProperty<BalancingGroup>();
        this.validation = false;
        this.validProperty = new ValidProperty(this);
        this.validProperty.bind((ObservableValue<? extends Boolean>)DependentBinding.get(this::computeValid, this.contract, this.valueProperty(), this.currentUser));
    }

    private boolean computeValid() {
        return !this.validation || this.isAssignmentValid();
    }

    private boolean isAssignmentValid() {
        Contract contract = this.getContract();
        DeliveryArea deliveryArea = (DeliveryArea)this.getValue();
        BalancingGroup balancingGroup = this.getBalancingGroup();
        User user = (User)this.currentUser.getValue();
        return contract == null || balancingGroup == null || user == null || deliveryArea == null || this.assignmentService.isUserAssignedToBgProductAndDa(user, (String)balancingGroup.getId(), (String)contract.getProduct().getId(), (String)deliveryArea.getId());
    }

    @Override
    protected DeliveryArea getDefaultValue(DeliveryArea deliveryArea) {
        return deliveryArea;
    }

    @Override
    protected String getDefaultLabel() {
        return Util.getLabel("commons_area");
    }

    @Override
    boolean isAnOption(DeliveryArea area) {
        return area.isActiveOrSuspended() && (this.contract.get() == null || ((Contract)this.contract.get()).getCompoundStatus().getDeliveryAreaStatusOrInactive(area).isVisible());
    }

    @Override
    boolean isMineOption(DeliveryArea area) {
        return this.isAnOption(area);
    }

    @Override
    public List<DeliveryArea> getListedItems() {
        return Collections.unmodifiableList(super.getListedItems());
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public BalancingGroup getBalancingGroup() {
        return (BalancingGroup)this.balancingGroup.get();
    }

    public ObjectProperty<BalancingGroup> balancingGroupProperty() {
        return this.balancingGroup;
    }

    public void setBalancingGroup(BalancingGroup balancingGroup) {
        this.balancingGroup.set(balancingGroup);
    }
}

