/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessageSeverityWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import javafx.animation.FadeTransition;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Duration;

public class FadeoutMessage
extends Label {
    public static final Duration VISIBLE_DURATION = Duration.millis(5000.0);
    public static final Duration FADEOUT_DURATION = Duration.millis(500.0);
    private final ColorFlash flash;
    private final FadeTransition fadeOut;
    private final Tooltip tooltip;
    private final MessageSeverityWidget severityWidget;

    public FadeoutMessage() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected FadeoutMessage(ApplicationContext applicationContext) {
        this.flash = applicationContext.getService(ColorFlashFactory.class).getFlash(this);
        this.severityWidget = new MessageSeverityWidget();
        this.severityWidget.setVisible(false);
        this.setGraphic(this.severityWidget);
        this.setTextOverrun(OverrunStyle.ELLIPSIS);
        HBox.setHgrow(this, Priority.ALWAYS);
        this.setAlignment(Pos.CENTER_LEFT);
        this.fadeOut = new FadeTransition(FADEOUT_DURATION, this);
        this.fadeOut.setDelay(VISIBLE_DURATION);
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        this.tooltip = new Tooltip();
        this.tooltip.textProperty().bind(this.textProperty());
        this.tooltip.setWrapText(true);
        this.fadeOut.setOnFinished(event -> Tooltip.uninstall(this, this.tooltip));
    }

    public void showMessage(Message message) {
        this.severityWidget.setVisible(true);
        this.severityWidget.setValue(message.getSeverity());
        this.setText(message.getMessageText());
        this.playEffects();
    }

    public void showMessage(String message) {
        this.severityWidget.setVisible(false);
        this.severityWidget.setValue(null);
        this.setText(message);
        this.playEffects();
    }

    private void playEffects() {
        this.fadeOut.stop();
        this.setOpacity(1.0);
        Tooltip.install(this, this.tooltip);
        this.fadeOut.playFromStart();
        this.flash.flash(true);
    }
}

