/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.MarketStateQueries;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.MarketStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.MarketStatusWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.eventbus.EventBus;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.joda.time.DateTime;

public class ClockPanel
extends HBox
implements Destroyable,
BottomToolbarNode {
    private static final String MARKET_HALT_STYLE_CLASS = "marketHalt";
    private static final int UPDATE_INTERVAL = 200;
    private final ScheduledFuture<?> updateTimer;
    @FXML
    private Label serverTimeLabel;
    @FXML
    private MarketStatusWidget statusWidget;
    private final ObjectProperty<DateTime> exchangeTime;
    private final MarketStateQueries marketStateQueries;
    private final UserService userService;
    private final LocalService localService;
    private final EventBus eventBus;
    private final TimeService timeService;

    public ClockPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected ClockPanel(ApplicationContext appContext) {
        this.eventBus = appContext.getService(EventBus.class);
        this.userService = appContext.getService(UserService.class);
        this.localService = appContext.getService(LocalService.class);
        this.marketStateQueries = appContext.getService(MarketStateQueries.class);
        this.timeService = appContext.getService(TimeService.class);
        this.exchangeTime = new SimpleObjectProperty<DateTime>(DateTime.now());
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.updateTimer = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class).scheduleAtFixedRate(FxUtil.wrapWithRunInFxThread(this::updateTimesAndStati), 0L, 200L, TimeUnit.MILLISECONDS);
        this.eventBus.register(this);
    }

    public void initialize() {
        this.serverTimeLabel.setPrefWidth(-1.0);
        this.serverTimeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.statusWidget.valueProperty().addListener((observable2, oldValue, newValue) -> StyleUtil.addStyleClass(this.serverTimeLabel, MARKET_HALT_STYLE_CLASS, newValue != MarketStatus.ACTIVE));
        this.serverTimeLabel.textProperty().bind(DependentBinding.get(this::computeText, this.exchangeTime));
        TooltipUtils.setTooltip(this.serverTimeLabel, this.getDescription());
    }

    private String computeText() {
        User ownUser = this.userService.getOwnUser();
        if (ownUser != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ownUser.getExchange().getName());
            sb.append(": ");
            sb.append(this.localService.formatDateTime((DateTime)this.exchangeTime.get()));
            sb.append(" ");
            sb.append(((DateTime)this.exchangeTime.get()).getZone().getShortName(((DateTime)this.exchangeTime.get()).getMillis(), this.localService.getConfiguredLocale()));
            sb.append(" (");
            sb.append((String)ownUser.getMember().getId());
            sb.append(" / ");
            sb.append(ownUser.getUserCode());
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    private void updateTimesAndStati() {
        DateTime newServerTime = this.timeService.getServerTime();
        Optional<MarketState> marketState = this.marketStateQueries.findMarketState().getFirst();
        this.statusWidget.setValue(marketState.map(MarketState::getStatus).orElse(null));
        this.exchangeTime.setValue(newServerTime);
    }

    @Override
    public void destroy() {
        this.updateTimer.cancel(false);
        this.eventBus.unregister(this);
    }

    @Override
    public Node getPreviewForConfigTable() {
        HBox hbox = new HBox();
        hbox.setSpacing(5.0);
        Label label2 = new Label();
        label2.textProperty().bind(this.serverTimeLabel.textProperty());
        label2.setDisable(true);
        Label label1 = new Label(Util.getLabel("commons_market_colon"));
        label1.setDisable(true);
        MarketStatusWidget statusWidget1 = new MarketStatusWidget();
        statusWidget1.valueProperty().bind(this.statusWidget.valueProperty());
        hbox.getChildren().addAll((Node[])new Node[]{label1, statusWidget1, label2});
        return hbox;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_mainPanel_clockPanel");
    }
}

