/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DropTargetParent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SplitPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.ComponentDroppedEventHandler;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelOverlay;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.TargetPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.GuiStateService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ComponentDragDone;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ComponentDragStartet;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class EditOverlay
extends StackPane
implements PanelOverlay,
Destroyable {
    private final DragAndDropService dragAndDropService;
    private final ApplicationContext applicationContext;
    private final PanelWrapper panelWrapper;
    private final EventBus eventBus;
    private final GuiStateService guiStateService;
    @FXML
    private Label componentName;
    @FXML
    private Rectangle topDropArea;
    @FXML
    private Rectangle rightDropArea;
    @FXML
    private Rectangle bottomDropArea;
    @FXML
    private Rectangle leftDropArea;
    @FXML
    private Rectangle centerDropArea;
    @FXML
    private Rectangle layoutPreview;
    @FXML
    private Pane controlsContainer;
    @FXML
    private ButtonWithIcon pasteButton;
    private final BooleanProperty shouldBeVisible;

    public EditOverlay(ApplicationContext applicationContext, PanelWrapper panelWrapper) {
        this.dragAndDropService = applicationContext.getService(DragAndDropService.class);
        this.applicationContext = applicationContext;
        this.panelWrapper = panelWrapper;
        this.guiStateService = applicationContext.getService(GuiStateService.class);
        this.shouldBeVisible = new SimpleBooleanProperty(this.guiStateService.isEditMode());
        this.eventBus = applicationContext.getService(EventBus.class);
        FXMLLoaderWithContext.loadCustomComponent(this);
        this.eventBus.register(this);
    }

    public void initialize() {
        this.topDropArea.widthProperty().bind(this.widthProperty());
        this.topDropArea.heightProperty().bind(this.heightProperty().multiply(0.2));
        this.initDropArea(this.topDropArea, Pos.TOP_CENTER);
        this.bottomDropArea.widthProperty().bind(this.widthProperty());
        this.bottomDropArea.heightProperty().bind(this.heightProperty().multiply(0.2));
        this.initDropArea(this.bottomDropArea, Pos.BOTTOM_CENTER);
        this.leftDropArea.widthProperty().bind(this.widthProperty().multiply(0.2));
        this.leftDropArea.heightProperty().bind(this.heightProperty());
        this.initDropArea(this.leftDropArea, Pos.CENTER_LEFT);
        this.rightDropArea.widthProperty().bind(this.widthProperty().multiply(0.2));
        this.rightDropArea.heightProperty().bind(this.heightProperty());
        this.initDropArea(this.rightDropArea, Pos.CENTER_RIGHT);
        this.centerDropArea.widthProperty().bind(this.widthProperty().multiply(0.6));
        this.centerDropArea.heightProperty().bind(this.heightProperty().multiply(0.6));
        this.initDropArea(this.centerDropArea, Pos.CENTER);
        this.pasteButton.disableProperty().bind(this.guiStateService.panelInClipBoardProperty().isNull());
        StackPane.setAlignment(this.controlsContainer, Pos.CENTER);
        this.initComponentNameLabel();
        if (this.panelWrapper.getPanel() instanceof TargetPanel) {
            this.getChildren().remove(this.controlsContainer);
            this.centerDropArea.widthProperty().bind(this.widthProperty());
            this.centerDropArea.heightProperty().bind(this.heightProperty());
            this.getChildren().removeAll((Node[])new Node[]{this.topDropArea, this.bottomDropArea, this.leftDropArea, this.rightDropArea});
        }
    }

    @Subscribe
    public void handleComponentDragStartet(ComponentDragStartet event) {
        this.controlsContainer.setMouseTransparent(true);
    }

    @Subscribe
    public void handleComponentDragDone(ComponentDragDone event) {
        this.controlsContainer.setMouseTransparent(false);
    }

    private void initComponentNameLabel() {
        this.componentName.setText(this.panelWrapper.getComponentName());
        this.componentName.setOnDragDetected(this::dragDetected);
        this.componentName.setCursor(Cursor.OPEN_HAND);
    }

    private void dragDetected(MouseEvent event) {
        Dragboard db = this.componentName.startDragAndDrop(event.isControlDown() ? TransferMode.COPY : TransferMode.MOVE);
        this.dragAndDropService.setComponent(db, this.panelWrapper.asPanelInClipBoard());
        event.consume();
    }

    @Override
    public Pane getOverlayPane() {
        return this;
    }

    @Override
    public ReadOnlyBooleanProperty shouldBeVisible() {
        return this.shouldBeVisible;
    }

    @Override
    public void destroy() {
        this.eventBus.unregister(this);
    }

    @FXML
    public void remove() {
        DropTargetParent dropTargetParent = this.panelWrapper.getDropTargetParent();
        if (dropTargetParent != null) {
            this.destroy();
            dropTargetParent.removeNode(this.panelWrapper);
        }
    }

    @FXML
    public void copy() {
        this.guiStateService.setPanelInClipBoard(this.panelWrapper.asPanelInClipBoard());
    }

    @FXML
    public void paste() {
        this.panelWrapper.destroy();
        DropTargetParent parent = this.panelWrapper.getDropTargetParent();
        AbstractPanel newPanel = PanelFactory.createPanel(this.guiStateService.getPanelInClipBoard(), this.applicationContext);
        PanelWrapper newPanelWrapper = new PanelWrapper(this.applicationContext, newPanel);
        if (parent instanceof SplitPanel) {
            SplitPanel splitPanel = (SplitPanel)parent;
            splitPanel.addComponent(splitPanel.getItems().indexOf(this.panelWrapper), SplitPanel.InsertionMode.REPLACE, newPanelWrapper);
        } else if (parent instanceof ContentTab) {
            ((ContentTab)parent).setContent(newPanelWrapper);
        }
    }

    @Subscribe
    public void notifyEditMode(EditEvent editEvent) {
        this.shouldBeVisible.setValue(editEvent.isEditMode());
    }

    private void initDropArea(Rectangle dropArea, Pos position) {
        dropArea.setOnDragEntered(event -> this.dragEntered((DragEvent)event, position));
        dropArea.setOnDragExited(event -> this.stopAnimation());
        dropArea.setOnDragDropped(new ComponentDroppedEventHandler(this.applicationContext, this.panelWrapper, position));
        dropArea.setOnDragOver(this::dragOver);
        StackPane.setAlignment(dropArea, position);
        dropArea.setFill(Color.TRANSPARENT);
    }

    private void dragOver(DragEvent dragEvent) {
        if (this.canBeDroppedHere(dragEvent)) {
            dragEvent.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            dragEvent.consume();
        }
    }

    private void dragEntered(DragEvent dragEvent, Pos target) {
        if (this.canBeDroppedHere(dragEvent)) {
            this.animateLayoutPreview(target);
        }
    }

    private boolean canBeDroppedHere(DragEvent dragEvent) {
        return this.dragAndDropService.hasComponentOrComponentClassName(dragEvent.getDragboard()) && (dragEvent.getGestureSource() != this.componentName || dragEvent.getTransferMode() == TransferMode.COPY);
    }

    private void showLayoutPreview() {
        this.getChildren().remove(this.layoutPreview);
        this.getChildren().add(0, this.layoutPreview);
    }

    private void stopAnimation() {
        this.getChildren().remove(this.layoutPreview);
    }

    private void animateLayoutPreview(Pos target) {
        double width;
        double y;
        double x;
        this.showLayoutPreview();
        ParallelTransition animatateRectangleTransition = new ParallelTransition();
        Duration duration = Duration.millis(250.0);
        FadeTransition fadeInTransition = new FadeTransition(duration, this.layoutPreview);
        fadeInTransition.setFromValue(this.layoutPreview.getOpacity());
        fadeInTransition.setToValue(1.0);
        double height = switch (target) {
            case Pos.TOP_CENTER -> {
                x = 0.0;
                y = 0.0;
                width = this.getWidth();
                yield this.getHeight() / 2.0;
            }
            case Pos.BOTTOM_CENTER -> {
                x = 0.0;
                y = this.getHeight() / 2.0;
                width = this.getWidth();
                yield this.getHeight() / 2.0;
            }
            case Pos.CENTER_RIGHT -> {
                x = this.getWidth() / 2.0;
                y = 0.0;
                width = this.getWidth() / 2.0;
                yield this.getHeight();
            }
            case Pos.CENTER_LEFT -> {
                x = 0.0;
                y = 0.0;
                width = this.getWidth() / 2.0;
                yield this.getHeight();
            }
            default -> {
                x = 0.0;
                y = 0.0;
                width = this.getWidth();
                yield this.getHeight();
            }
        };
        KeyFrame resizeStart = new KeyFrame(Duration.ZERO, new KeyValue(this.layoutPreview.widthProperty(), this.layoutPreview.getWidth()), new KeyValue(this.layoutPreview.heightProperty(), this.layoutPreview.getHeight()));
        KeyFrame resizeEnd = new KeyFrame(duration, new KeyValue(this.layoutPreview.widthProperty(), width), new KeyValue(this.layoutPreview.heightProperty(), height));
        Timeline resizeTransition = new Timeline(resizeStart, resizeEnd);
        KeyFrame moveStart = new KeyFrame(Duration.ZERO, new KeyValue(this.layoutPreview.xProperty(), this.layoutPreview.getX()), new KeyValue(this.layoutPreview.yProperty(), this.layoutPreview.getY()));
        KeyFrame moveEnd = new KeyFrame(duration, new KeyValue(this.layoutPreview.xProperty(), x), new KeyValue(this.layoutPreview.yProperty(), y));
        Timeline moveTransition = new Timeline(moveStart, moveEnd);
        animatateRectangleTransition.getChildren().addAll((Animation[])new Animation[]{fadeInTransition, resizeTransition, moveTransition});
        animatateRectangleTransition.playFromStart();
    }
}

