/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ConvertableToFxml;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DropTargetParent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.DisabledOverlay;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.EditOverlay;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.LoadingOverlay;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelInClipBoard;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ContentTabClosingEvent;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.effect.BoxBlur;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="panel")
public class PanelWrapper
extends StackPane
implements Destroyable,
ConvertableToFxml {
    private static final Logger LOG = LoggerFactory.getLogger(PanelWrapper.class);
    private final ContentTab.ContentTabLookup contentTabLookup;
    private final EventBus eventBus;
    private final ApplicationContext appContext;
    private final StringProperty persistentId;
    private EditOverlay editOverlay;
    private LoadingOverlay loadingOverlay;
    private DisabledOverlay disabledOverlay;
    private AbstractPanel panel;
    private DropTargetParent dropTargetParent;

    public PanelWrapper() {
        this(FXMLLoaderWithContext.getAppContext(), null);
    }

    public PanelWrapper(ApplicationContext appContext, AbstractPanel panel) {
        this.panel = panel;
        this.contentTabLookup = appContext.getService(ContentTab.ContentTabLookup.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.persistentId = new SimpleStringProperty();
        this.appContext = appContext;
        this.widthProperty().addListener(observable2 -> this.layoutChildren());
        this.heightProperty().addListener(observable2 -> this.layoutChildren());
        if (panel != null) {
            this.setPanel(panel);
        }
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        this.getChildren().stream().filter(Pane.class::isInstance).map(Pane.class::cast).forEach(pane -> pane.resize(this.getWidth(), this.getHeight()));
    }

    public void setPanel(AbstractPanel panel) {
        this.panel = panel;
        this.getChildren().add(0, panel);
        this.editOverlay = new EditOverlay(this.appContext, this);
        this.editOverlay.shouldBeVisible().addListener((o, o1, o2) -> this.setOverlays());
        this.loadingOverlay = new LoadingOverlay(this.appContext, panel.getClass().getAnnotation(PanelWithLoadingIndicator.class));
        this.loadingOverlay.shouldBeVisible().addListener((o, o1, o2) -> this.setOverlays());
        this.disabledOverlay = new DisabledOverlay(this.appContext, panel.getClass());
        this.disabledOverlay.shouldBeVisible().addListener((o, o1, o2) -> this.setOverlays());
        this.setOverlays();
        this.eventBus.register(this);
    }

    public AbstractPanel getPanel() {
        return this.panel;
    }

    private void setOverlays() {
        if (this.editOverlay.shouldBeVisible().get()) {
            this.getChildren().setAll((Node[])new Node[]{this.panel, this.editOverlay});
        } else if (this.loadingOverlay.shouldBeVisible().get()) {
            this.getChildren().setAll((Node[])new Node[]{this.panel, this.loadingOverlay});
        } else if (this.disabledOverlay.shouldBeVisible().get()) {
            this.getChildren().setAll((Node[])new Node[]{this.panel, this.disabledOverlay});
        } else {
            this.getChildren().setAll((Node[])new Node[]{this.panel});
        }
        this.layoutChildren();
        this.setPanelEffect();
    }

    private void setPanelEffect() {
        if (this.getChildren().size() == 1) {
            this.panel.setEffect(null);
        } else {
            this.panel.setEffect(new BoxBlur(6.0, 6.0, 1));
        }
    }

    @Override
    public String generateFxml() {
        return "<PanelWrapper persistentId=\"" + this.getPersistentId() + "\" >" + (String)(this.panel != null ? "<" + this.panel.getClass().getSimpleName() + "/>" : "") + "</PanelWrapper>";
    }

    public DropTargetParent getDropTargetParent() {
        return this.dropTargetParent;
    }

    public void setDropTargetParent(DropTargetParent dropTargetParent) {
        this.dropTargetParent = dropTargetParent;
        ContentTab contentTab = this.getContentTab();
        if (dropTargetParent != null && contentTab != null && this instanceof StorableComponent) {
            contentTab.registerNewStorableComponent((StorableComponent)((Object)this));
        }
    }

    @Subscribe
    public void handleContentTabClosingEvent(ContentTabClosingEvent contentTabClosingEvent) {
        if (contentTabClosingEvent.getContentTab().containsNode(this)) {
            this.destroy();
        }
    }

    protected ContentTab getContentTab() {
        return this.contentTabLookup.findContentTabOfNode(this);
    }

    protected ContentTab.ContentTabLookup getContentTabLookup() {
        return this.contentTabLookup;
    }

    @Override
    public void destroy() {
        this.unregisterAsStorableComponent();
        LOG.info("Unregistering {}", (Object)this.getClass().getSimpleName());
        this.eventBus.unregister(this);
        this.loadingOverlay.destroy();
        this.editOverlay.destroy();
        this.disabledOverlay.destroy();
        this.destroyChildrenRecursively(this);
    }

    protected void unregisterAsStorableComponent() {
        ContentTab contentTabOfNode = this.getContentTab();
        if (this instanceof StorableComponent && contentTabOfNode != null) {
            contentTabOfNode.unregisterStorableComponent((StorableComponent)((Object)this));
        }
    }

    public String getPersistentId() {
        if (this.persistentId.get() == null) {
            this.persistentId.setValue(UUID.randomUUID().toString());
        }
        return (String)this.persistentId.get();
    }

    public void setPersistentId(String persistentId) {
        this.persistentId.setValue(persistentId);
    }

    public String getComponentName() {
        return Optional.ofNullable(this.panel).map(Object::getClass).map(panelClass -> panelClass.getAnnotation(DraggableComponent.class)).map(annotation -> Strings.isNullOrEmpty(annotation.nameKey()) ? null : Util.getLabel(annotation.nameKey())).orElse(null);
    }

    protected PanelInClipBoard asPanelInClipBoard() {
        return new PanelInClipBoard(this.panel);
    }

    @Override
    protected double computeMinWidth(double height) {
        if (this.panel != null) {
            return this.panel.minWidth(height);
        }
        return super.computeMinWidth(height);
    }

    @Override
    protected double computeMinHeight(double width) {
        if (this.panel != null) {
            return this.panel.minHeight(width);
        }
        return super.computeMinHeight(width);
    }

    @Override
    protected double computePrefWidth(double height) {
        if (this.panel != null) {
            return this.panel.prefWidth(height);
        }
        return super.computePrefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width) {
        if (this.panel != null) {
            return this.panel.prefHeight(width);
        }
        return super.computePrefHeight(width);
    }

    @Override
    protected double computeMaxWidth(double height) {
        if (this.panel != null) {
            return this.panel.maxWidth(height);
        }
        return super.computeMaxWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width) {
        if (this.panel != null) {
            return this.panel.maxHeight(width);
        }
        return super.computeMaxHeight(width);
    }

    public boolean isStoreable() {
        return this.panel instanceof StorableComponent;
    }

    @Override
    public String toString() {
        if (this.panel != null) {
            return this.getComponentName() + " " + this.panel.toString();
        }
        return super.toString();
    }
}

