/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.message;

import com.deutscheboerse.comxerv.comtrader.entities.Message;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class MessageAppender
implements Consumer<Message> {
    private static final int ITERATION_SEARCH_LIMIT = 3;
    private final int maxMessages;
    private final List<Message> messages;

    public MessageAppender(int maxMessages, List<Message> messages) {
        this.maxMessages = maxMessages;
        this.messages = messages;
    }

    @Override
    public void accept(Message message) {
        int size = this.messages.size();
        if (size < this.maxMessages) {
            this.add(message);
        } else if (size >= this.maxMessages && message.compareTo(this.messages.get(size - 1)) > 0) {
            this.add(message);
            this.messages.remove(this.maxMessages);
        }
    }

    private void add(Message message) {
        for (int i = 0; i < 3 && i < this.messages.size(); ++i) {
            if (message.compareTo(this.messages.get(i)) <= 0) continue;
            this.messages.add(i, message);
            return;
        }
        int index = Collections.binarySearch(this.messages, message, Comparator.reverseOrder());
        if (index >= 0) {
            this.messages.add(index, message);
        } else {
            this.messages.add(index * -1 - 1, message);
        }
    }
}

