/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntryRow;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookChangeType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTableViewSkin;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.control.table.NoSelectionTableViewSelectionModel;
import com.deutscheboerse.ui.jfx.util.control.table.TableViewSkinWithPileCleaner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import org.joda.time.DateTime;

public class ExtendedOrderbookTableView
extends TableView<ExtendedOrderbookEntryRow> {
    private final boolean adminPanel;
    private final ObjectProperty<Orderbook> orderbook;
    private final Map<Integer, Integer> buyChanges;
    private final Map<Integer, Integer> sellChanges;

    public ExtendedOrderbookTableView(boolean adminPanel, boolean scrollLess) {
        this.adminPanel = adminPanel;
        this.orderbook = new SimpleObjectProperty<Object>(null);
        this.setSelectionModel(new NoSelectionTableViewSelectionModel<ExtendedOrderbookEntryRow>(this));
        this.getFocusModel().focus(-1);
        this.buyChanges = new HashMap<Integer, Integer>();
        this.sellChanges = new HashMap<Integer, Integer>();
        StyleUtil.addStyleClasses(this, "noFocus", "extendedOrderbookTable", "borderTable", "horizontalScrollLess");
        if (scrollLess) {
            StyleUtil.addStyleClasses(this, "scrollLess");
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ExtendedOrderbookTableViewSkin<ExtendedOrderbookEntryRow>(this);
    }

    protected void forceCleanPile() {
        Skin<?> skin = this.getSkin();
        if (skin instanceof TableViewSkinWithPileCleaner) {
            ((TableViewSkinWithPileCleaner)skin).forceCleanPile();
        }
    }

    protected void updateTableContent(List<ExtendedOrderbookEntry> newContent, Direction dir) {
        Map<Integer, Integer> changes = dir == Direction.BUY ? this.buyChanges : this.sellChanges;
        changes.clear();
        if (newContent.isEmpty()) {
            ArrayList<ExtendedOrderbookEntryRow> newItems = new ArrayList<ExtendedOrderbookEntryRow>();
            for (int i = 0; i < this.getItems().size(); ++i) {
                ExtendedOrderbookEntry sell;
                ExtendedOrderbookEntry buy = dir == Direction.BUY ? null : ((ExtendedOrderbookEntryRow)this.getItems().get(i)).getOrderbookEntry(Direction.BUY);
                ExtendedOrderbookEntry extendedOrderbookEntry = sell = dir == Direction.SELL ? null : ((ExtendedOrderbookEntryRow)this.getItems().get(i)).getOrderbookEntry(Direction.SELL);
                if (buy == null && sell == null) continue;
                newItems.add(new ExtendedOrderbookEntryRow(buy, sell));
            }
            this.getItems().setAll(newItems.isEmpty() ? Collections.singletonList(new ExtendedOrderbookEntryRow(null, null)) : newItems);
        } else {
            ObservableList<ExtendedOrderbookEntryRow> oldContent = this.getItems();
            for (int index = 0; index < newContent.size(); ++index) {
                ExtendedOrderbookEntry newEntry = newContent.get(index);
                boolean isNew = this.isNew(newEntry);
                if (!isNew) continue;
                if (index < oldContent.size() && oldContent.get(index) != null && ((ExtendedOrderbookEntryRow)oldContent.get(index)).getOrderbookEntry(dir) != null) {
                    ExtendedOrderbookEntry oldEntry = ((ExtendedOrderbookEntryRow)oldContent.get(index)).getOrderbookEntry(dir);
                    boolean priceQuals = oldEntry.getPrice().equals(newEntry.getPrice());
                    boolean quantityEquals = oldEntry.getQuantity().equals(newEntry.getQuantity());
                    if (!priceQuals && !quantityEquals) {
                        changes.put(index, ExtendedOrderbookChangeType.ANY_MASK);
                        continue;
                    }
                    if (!priceQuals) {
                        changes.put(index, ExtendedOrderbookChangeType.PRICE.asMask());
                        continue;
                    }
                    if (quantityEquals) continue;
                    changes.put(index, ExtendedOrderbookChangeType.QUANTITY.asMask());
                    continue;
                }
                changes.put(index, ExtendedOrderbookChangeType.ANY_MASK);
            }
            ArrayList<ExtendedOrderbookEntryRow> newItems = new ArrayList<ExtendedOrderbookEntryRow>();
            for (int i = 0; i < Math.max(newContent.size(), this.getItems().size()); ++i) {
                ExtendedOrderbookEntry buy = this.getExtendedOrderbookEntry(newContent, dir, Direction.BUY, oldContent, i);
                ExtendedOrderbookEntry sell = this.getExtendedOrderbookEntry(newContent, dir, Direction.SELL, oldContent, i);
                if (buy == null && sell == null) continue;
                newItems.add(new ExtendedOrderbookEntryRow(buy, sell));
            }
            this.getItems().setAll(newItems);
        }
    }

    private ExtendedOrderbookEntry getExtendedOrderbookEntry(List<ExtendedOrderbookEntry> newContent, Direction currentDir, Direction contentDir, ObservableList<ExtendedOrderbookEntryRow> oldContent, int i) {
        ExtendedOrderbookEntry extendedOrderbookEntry = currentDir == contentDir ? (i < newContent.size() ? newContent.get(i) : null) : (i < oldContent.size() && oldContent.get(i) != null ? ((ExtendedOrderbookEntryRow)oldContent.get(i)).getOrderbookEntry(contentDir) : null);
        return extendedOrderbookEntry;
    }

    private boolean isNew(ExtendedOrderbookEntry newEntry) {
        return DateTime.now().getMillis() - newEntry.getAddedTimestamp() < 500L;
    }

    public boolean shouldFlash(int index, Direction direction, int flashMask) {
        Map<Integer, Integer> changes = direction == Direction.BUY ? this.buyChanges : this.sellChanges;
        return (changes.getOrDefault(index, 0) & flashMask) != 0 && index >= 0 && index < this.getItems().size() && ((ExtendedOrderbookEntryRow)this.getItems().get(index)).getOrderbookEntry(direction) != null && this.isNew(((ExtendedOrderbookEntryRow)this.getItems().get(index)).getOrderbookEntry(direction));
    }

    public boolean isAdminPanel() {
        return this.adminPanel;
    }

    public Orderbook getOrderbook() {
        return (Orderbook)this.orderbook.get();
    }

    public ObjectProperty<Orderbook> orderbookProperty() {
        return this.orderbook;
    }

    public void setOrderbook(Orderbook orderbook) {
        this.orderbook.set(orderbook);
    }
}

