/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderQuoteUI;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Stage;

@Singleton
public class OrderQuotePanel
extends FXMLBorderPane
implements OrderQuoteUI {
    private final LocalService localService;
    private OrderQuoteNotification orderQuote;
    private final Stage window;
    @FXML
    private Label productText;
    @FXML
    private Label contractText;
    @FXML
    private Label qtyText;
    @FXML
    private Label directionText;
    @FXML
    private Label deliveryAreaText;
    @FXML
    private Label timeText;

    @Inject
    public OrderQuotePanel(ApplicationContext appContext) {
        super(appContext);
        this.localService = appContext.getService(LocalService.class);
        this.window = appContext.getService(UtilityStages.class).withKey(OrderQuotePanel.class.getName()).get();
        this.loadFxml();
        this.window.setScene(new Scene(this));
    }

    @Override
    public void showOrderQuoteNotification(OrderQuoteNotification orderQuoteNotification) {
        this.orderQuote = orderQuoteNotification;
        this.productText.setText(this.orderQuote.getContract().getProduct().getName());
        this.contractText.setText(this.orderQuote.getContract().getName());
        this.qtyText.setText(this.orderQuote.getQuantity().toString());
        this.directionText.setText(this.orderQuote.getDirection().getDescription());
        this.deliveryAreaText.setText(this.orderQuote.getDeliveryArea().getName());
        this.timeText.setText(this.localService.formatDateTime(this.orderQuote.getTimestmp()));
        StyleUtil.addStyleClass(this, "buy", "sell", orderQuoteNotification.getDirection().isBuy());
        this.window.show();
    }

    @FXML
    public void close() {
        this.window.hide();
    }

    @FXML
    public void more() {
        this.getAppContext().getService(OrderPopup.class).showOrderRequestPopup(this.orderQuote, this);
        this.close();
    }
}

