/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SettingsPanelProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryRule;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryRuleDirection;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.StringUtils;

@OverrideGuiConfiguration(field="#this", overrideId="OrderValidationSettingsPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class OrderValidationSettingsPane
extends BorderPane
implements SettingsSection {
    protected static final int DEFAULT_QTY_SHIFT = 1;
    protected static final long DEFAULT_QTY_DELTA = 1L;
    protected static final int DEFAULT_PRC_SHIFT = 2;
    protected static final long DEFAULT_PRC_DELTA = 1L;
    private final ObjectProperty<OrderEntryRule> currentOrderEntryRule;
    private final BooleanProperty modifying = new SimpleBooleanProperty(false);
    private final BooleanProperty valid = new SimpleBooleanProperty(false);
    private final UserAlertService userAlertService;
    private final OrderEntryProtectionService orderEntryProtectionService;
    @FXML
    private Button addButton;
    @FXML
    private Button modifyButton;
    @FXML
    private Button deleteOrCancelButton;
    @FXML
    private TableView<OrderEntryRule> orderEntryRuleTableView;
    @FXML
    private SettingsPanelProductField productField;
    @FXML
    private ChoiceBox<OrderEntryRuleDirection> directionField;
    @FXML
    private SimpleLongDisplayValueField lowerPriceField;
    @FXML
    private SimpleLongDisplayValueField upperPriceField;
    @FXML
    private SimpleLongDisplayValueField quantityField;
    @FXML
    private SimpleLongDisplayValueField amountField;
    private final ApplicationContext appContext;

    public OrderValidationSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OrderValidationSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.orderEntryProtectionService = appContext.getService(OrderEntryProtectionService.class);
        this.currentOrderEntryRule = new SimpleObjectProperty<OrderEntryRule>(new OrderEntryRule());
        this.userAlertService = appContext.getService(UserAlertService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.restoreState();
        this.orderEntryRuleTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.addButton.disableProperty().bind(this.modifying.or(this.valid.not()));
        this.deleteOrCancelButton.disableProperty().bind(this.modifying.not().and(Bindings.isEmpty(this.orderEntryRuleTableView.getSelectionModel().getSelectedItems())));
        this.modifyButton.disableProperty().bind(this.modifying.and(this.valid.not()).or(this.modifying.not().and(Bindings.size(this.orderEntryRuleTableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1))));
        this.addButton.visibleProperty().bind(this.modifying.not());
        this.modifying.addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.deleteOrCancelButton.setText(Util.getLabel("commons_cancel"));
            } else {
                this.deleteOrCancelButton.setText(Util.getLabel("commons_remove"));
            }
        });
        this.addPrcFieldFocusChangeListener(this.lowerPriceField);
        this.addPrcFieldFocusChangeListener(this.upperPriceField);
        this.addQtyFieldFocusChangeListener(this.quantityField);
        this.directionField.getItems().addAll((OrderEntryRuleDirection[])OrderEntryRuleDirection.values());
        this.directionField.setValue(OrderEntryRuleDirection.BOTH);
        this.valid.bind(this.productField.validProperty().and(this.lowerPriceField.validProperty()).and(this.upperPriceField.validProperty().and(this.quantityField.validProperty())));
        this.appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    private void addPrcFieldFocusChangeListener(SimpleLongDisplayValueField field) {
        field.textFieldFocusedProperty().addListener((observable2, wasFocused, isFocused) -> {
            if (isFocused.booleanValue() || field.isValid()) {
                Product product = (Product)this.productField.getValue();
                long delta = product != null ? product.getPriceTickSize().getValue() : 1L;
                int shift = product != null ? product.getPriceDecimalShift() : 2;
                field.setDelta((int)delta);
                if (field.getValue() != null) {
                    field.setValue(field.getValue().applyShift(shift));
                }
                LongDisplayValue minPrice = product != null ? product.getPriceMinValue() : new LongDisplayValue(Long.MIN_VALUE, shift);
                LongDisplayValue maxPrice = product != null ? product.getPriceMaxValue() : new LongDisplayValue(Long.MAX_VALUE, shift);
                field.setMinimum(minPrice);
                field.setMaximum(maxPrice);
            } else if (!field.isValid()) {
                field.setValue(null);
            }
        });
    }

    private void addQtyFieldFocusChangeListener(SimpleLongDisplayValueField field) {
        field.textFieldFocusedProperty().addListener((observable2, wasFocused, isFocused) -> {
            if (isFocused.booleanValue() || field.isValid()) {
                Product product = (Product)this.productField.getValue();
                long delta = product != null ? product.getQuantityLotSize().getValue() : 1L;
                int shift = product != null ? product.getQuantityDecimalShift() : 1;
                field.setDelta((int)delta);
                if (field.getValue() != null) {
                    field.setValue(field.getValue().applyShift(shift));
                }
                LongDisplayValue minQty = product != null ? product.getQuantityMinValue() : new LongDisplayValue(1L, shift);
                LongDisplayValue maxQty = product != null ? product.getQuantityMaxValue() : new LongDisplayValue(Long.MAX_VALUE, shift);
                field.setMinimum(minQty);
                field.setMaximum(maxQty);
            } else if (!field.isValid()) {
                field.setValue(null);
            }
        });
    }

    private void restoreState() {
        this.orderEntryRuleTableView.setItems(FXCollections.observableArrayList(this.orderEntryProtectionService.getOrderEntryRules()));
    }

    private boolean allValuesSame(List<Product> products, Function<? super Product, ?> value) {
        return products.stream().map(value).collect(Collectors.toSet()).size() == 1;
    }

    @FXML
    public void addOrderEntryRule() {
        if (this.isFormValid()) {
            OrderEntryRule newRule = (OrderEntryRule)this.currentOrderEntryRule.get();
            this.ruleModificationFinished();
            this.orderEntryRuleTableView.getItems().add(newRule);
            this.resetEntryForm();
            this.currentOrderEntryRule.setValue(new OrderEntryRule());
        }
    }

    @FXML
    public void modifyOrderEntryRule() {
        OrderEntryRule selectedItem = (OrderEntryRule)this.orderEntryRuleTableView.getSelectionModel().getSelectedItem();
        if (this.modifying.get() && this.isFormValid()) {
            this.ruleModificationFinished();
        } else if (selectedItem != null) {
            this.startRuleModification(selectedItem);
        }
    }

    private void ruleModificationFinished() {
        OrderEntryRule orderEntryRule = (OrderEntryRule)this.currentOrderEntryRule.get();
        orderEntryRule.setProductName(StringUtils.isEmpty(this.productField.getText()) ? "*" : this.productField.getText());
        orderEntryRule.setLowerPrice(this.lowerPriceField.getValue());
        orderEntryRule.setUpperPrice(this.upperPriceField.getValue());
        orderEntryRule.setQuantity(this.quantityField.getValue());
        orderEntryRule.setAmount(this.amountField.getValue());
        orderEntryRule.setDirection(this.directionField.getValue());
        this.modifying.setValue(false);
        this.resetEntryForm();
        this.currentOrderEntryRule.setValue(new OrderEntryRule());
    }

    private void startRuleModification(OrderEntryRule ruleToModify) {
        this.modifying.setValue(true);
        this.currentOrderEntryRule.setValue(ruleToModify);
        this.resetEntryForm();
        this.lowerPriceField.setValue(ruleToModify.getLowerPrice());
        this.upperPriceField.setValue(ruleToModify.getUpperPrice());
        this.quantityField.setValue(ruleToModify.getQuantity());
        this.amountField.setValue(ruleToModify.getAmount());
        this.productField.setText(ruleToModify.getProductName().equals("*") ? "" : ruleToModify.getProductName());
        this.directionField.valueProperty().setValue(ruleToModify.getDirection());
    }

    private boolean isFormValid() {
        LongDisplayValue lower = this.lowerPriceField.getValue();
        LongDisplayValue upper = this.upperPriceField.getValue();
        if (lower != null && upper != null && lower.compareTo(upper) > 0) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("settingsPanel_orderValidationTab_lower_upper_price_error"), Util.getLabel("settingsPanel_orderValidationTab_lower_upper_price_error_detail", lower.getDisplayValue(), upper.getDisplayValue()), UserAlertService.Flag.ERROR);
            return false;
        }
        return true;
    }

    private void resetEntryForm() {
        this.lowerPriceField.setValue(null);
        this.upperPriceField.setValue(null);
        this.quantityField.setValue(null);
        this.amountField.setValue(null);
        this.productField.textProperty().setValue("");
        this.directionField.setValue(OrderEntryRuleDirection.BOTH);
    }

    @FXML
    public void deleteOrCancelOrderEntryRule() {
        if (this.modifying.getValue().booleanValue()) {
            this.modifying.setValue(false);
            this.resetEntryForm();
            this.currentOrderEntryRule.setValue(new OrderEntryRule());
        } else {
            ObservableList deleteIndices = this.orderEntryRuleTableView.getSelectionModel().getSelectedIndices();
            for (int i = deleteIndices.size() - 1; i >= 0; --i) {
                this.orderEntryRuleTableView.getItems().remove((Integer)deleteIndices.get(i));
            }
        }
    }

    @Override
    public boolean applyChanges() {
        this.orderEntryProtectionService.storeOrderEntryRule(this.orderEntryRuleTableView.getItems());
        return true;
    }

    @Override
    public void cancelChanges() {
        this.restoreState();
    }

    @Override
    public void resetToDefault() {
        this.orderEntryRuleTableView.getItems().clear();
        this.resetEntryForm();
    }
}

