/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.ChoiceBoxOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingAction;
import com.deutscheboerse.ui.jfx.util.FxUtil;

@OverrideGuiConfiguration(field="listedItems", overrideId="TradingActionChoiceBox", strategy=ChoiceBoxOverrideGuiStrategy.class)
public class TradingActionChoiceBox
extends DisplayNameArrowKeyBlockingChoiceBox<TradingAction> {
    private final OverrideGuiConfigurationsExecutor overrideGuiConfigurationsExecutor;
    private final TradingActionService tradingActionService;
    private OrderbookEntryType type;

    public TradingActionChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TradingActionChoiceBox(ApplicationContext appContext) {
        this.overrideGuiConfigurationsExecutor = appContext.getService(OverrideGuiConfigurationsExecutor.class);
        this.tradingActionService = appContext.getService(TradingActionService.class);
    }

    public void populate() {
        this.setListedItems(this.tradingActionService.getTradingActionsOfCurrentUser(this.type));
        this.overrideGuiConfigurationsExecutor.registerAndApply(this);
    }

    public OrderbookEntryType getType() {
        return this.type;
    }

    public void setType(OrderbookEntryType type) {
        this.type = type;
        FxUtil.runInFxThread(this::populate);
    }
}

