/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.OrderbookCollapsibleInfo;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class OrderbookCollapsibleCellFactory<S>
implements Callback<TableColumn<S, OrderbookCollapsibleInfo>, TableCell<S, OrderbookCollapsibleInfo>> {
    @Override
    public TableCell<S, OrderbookCollapsibleInfo> call(TableColumn<S, OrderbookCollapsibleInfo> collapsibleOrderbookOrderbookCollapsibleInfoTableColumn) {
        MoreButtonTableCell moreButtonTableCell = new MoreButtonTableCell();
        ColorInvalidationListener.registerForColoredTableColumn(collapsibleOrderbookOrderbookCollapsibleInfoTableColumn, moreButtonTableCell);
        return moreButtonTableCell;
    }

    private static final class MoreButtonTableCell<S>
    extends TableCell<S, OrderbookCollapsibleInfo> {
        private final Button plusMinusButton = new Button("");
        private final IconView buttonGraphic;

        public MoreButtonTableCell() {
            this.plusMinusButton.setFocusTraversable(false);
            this.buttonGraphic = new IconView();
            this.plusMinusButton.setGraphic(this.buttonGraphic);
            this.setGraphic(this.plusMinusButton);
            this.setAlignment(Pos.TOP_CENTER);
        }

        @Override
        protected void updateItem(OrderbookCollapsibleInfo orderbookCollapsibleInfo, boolean empty) {
            super.updateItem(orderbookCollapsibleInfo, empty);
            if (empty || orderbookCollapsibleInfo == null) {
                this.plusMinusButton.setOnAction(null);
                this.plusMinusButton.visibleProperty().unbind();
                this.plusMinusButton.setVisible(false);
            } else {
                this.plusMinusButton.setOnAction(event -> orderbookCollapsibleInfo.setCollapsed(!orderbookCollapsibleInfo.getCollapsed()));
                ReadOnlyBooleanProperty needsMoreProperty = orderbookCollapsibleInfo.needsMoreProperty();
                this.plusMinusButton.visibleProperty().bind(needsMoreProperty);
                DependentBinding<String> iconStyleClass = DependentBinding.get(() -> this.getButtonImagePath(orderbookCollapsibleInfo), orderbookCollapsibleInfo.collapsedProperty());
                this.buttonGraphic.iconStyleClassProperty().bind(iconStyleClass);
            }
        }

        private String getButtonImagePath(OrderbookCollapsibleInfo orderbookCollapsibleInfo) {
            return orderbookCollapsibleInfo.getCollapsed() ? "button-expand-all" : "button-collapse-all";
        }
    }
}

