/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage;

import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnColor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColoredTableColumn;
import java.io.Serializable;
import javafx.scene.control.TableColumn;

public class StorableTableColumnDescriptor
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final boolean visible;
    private final ColumnColor color;
    private final double width;
    private final TableColumn.SortType sortType;

    private StorableTableColumnDescriptor(boolean visible, double width, TableColumn.SortType sortType, ColumnColor color) {
        this.visible = visible;
        this.width = width;
        this.color = color;
        this.sortType = sortType;
    }

    private StorableTableColumnDescriptor(boolean visible, double width, TableColumn.SortType sortType) {
        this(visible, width, sortType, null);
    }

    protected static StorableTableColumnDescriptor fromTableColumn(TableColumn<?, ?> tableColumn) {
        if (tableColumn instanceof ColoredTableColumn) {
            ColumnColor currentColor = ((ColoredTableColumn)tableColumn).getColor();
            return new StorableTableColumnDescriptor(tableColumn.isVisible(), tableColumn.getWidth(), tableColumn.getSortType(), currentColor);
        }
        return new StorableTableColumnDescriptor(tableColumn.isVisible(), tableColumn.getWidth(), tableColumn.getSortType());
    }

    public void applyToTableColumn(TableColumn<?, ?> tableColumn) {
        tableColumn.setVisible(this.visible);
        tableColumn.setPrefWidth(this.width);
        tableColumn.setSortType(this.sortType);
        if (tableColumn instanceof ColoredTableColumn && this.color != null) {
            ((ColoredTableColumn)tableColumn).setColor(this.color);
        }
    }

    public String toString() {
        return "StorableTableColumnDescriptor{visible=" + this.visible + ", color='" + String.valueOf((Object)this.color) + "', width=" + this.width + ", sortType=" + String.valueOf((Object)this.sortType) + "}";
    }
}

