/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.trade;

import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import java.util.Optional;

public class OrderInfoCellCustomizer
extends GenericCellCustomizer<FullTrade, Long> {
    private Direction direction = Direction.BUY;

    @Override
    protected String getTooltipText(Long cellItem, FullTrade rowValue, String defaultTooltipText) {
        return Optional.of(rowValue).map(trade -> this.direction.isBuy() ? trade.getBuyOrder() : trade.getSellOrder()).map(this::getTooltipText).orElse(null);
    }

    private String getTooltipText(Trade.OrderInfo orderInfo) {
        StringBuilder toolTipText = new StringBuilder();
        toolTipText.append("Text: ").append(orderInfo.getText()).append("\n");
        toolTipText.append("DA: ").append(orderInfo.getDeliveryArea()).append("\n");
        if (orderInfo.getBalancingGroup() != null) {
            toolTipText.append("BG: ").append(orderInfo.getBalancingGroup().getName());
        }
        return toolTipText.toString();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }
}

