/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.ContextMenuOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

@OverrideGuiConfiguration(field="items", overrideId="FullTradeContextMenu", strategy=ContextMenuOverrideGuiStrategy.class)
public class FullTradeContextMenu
extends ContextMenu {
    protected FullTradeContextMenu(List<FullTrade> trades, TradeService tradeService) {
        if (tradeService.isTradeCancellationPossible(trades)) {
            MenuItem cancel = new MenuItem(Util.getLabel("commons_cancel"));
            cancel.setGraphic(new IconView(ContextMenuIcon.CANCEL.getIconStyleClass()));
            cancel.setOnAction(event -> tradeService.cancelTrades(trades));
            this.getItems().add(cancel);
        }
        if (tradeService.isTradeRecallProcessingPossible(trades)) {
            MenuItem process = new MenuItem(Util.getLabel("commons_processTrade"));
            process.setOnAction(event -> tradeService.processRecallTrades(trades));
            process.setGraphic(new IconView(ContextMenuIcon.PROCESS.getIconStyleClass()));
            this.getItems().add(process);
        }
    }

    public static ContextMenu createContextMenu(List<FullTrade> trades, ApplicationContext appContext) {
        FullTradeContextMenu contextMenu = new FullTradeContextMenu(trades, appContext.getService(TradeService.class));
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(contextMenu);
        return contextMenu;
    }
}

