/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTree;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTreeContext;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.layout.HBox;

public class SlideInContractTreePane
extends HBox {
    protected static final String LEFT_ICON_STYLE_CLASS = "button-orderbook-navigation-left";
    protected static final String RIGHT_ICON_STYLE_CLASS = "button-orderbook-navigation-right";
    @FXML
    private IconView toggleContractTreeButton;
    private final ContractTree contractTree;
    private final SimpleBooleanProperty contractTreeVisible;

    public SlideInContractTreePane(ApplicationContext appContext, ContractTreeContext contractTreeContext) {
        this.contractTree = new ContractTree(appContext, contractTreeContext);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.contractTreeVisible = new SimpleBooleanProperty(true);
        this.contractTreeVisible.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.toggleContractTreeButton.setIconStyleClass(LEFT_ICON_STYLE_CLASS);
                if (!this.getChildren().contains(this.contractTree)) {
                    this.getChildren().add(this.contractTree);
                }
            } else {
                this.toggleContractTreeButton.setIconStyleClass(RIGHT_ICON_STYLE_CLASS);
                this.getChildren().remove(this.contractTree);
            }
        }));
        this.contractTreeVisible.set(false);
    }

    public void toggleContractTree() {
        if (this.contractTreeVisible.get()) {
            this.hideContractTree();
        } else {
            this.showContractTree();
        }
    }

    public void hideContractTree() {
        this.contractTreeVisible.set(false);
    }

    public void showContractTree() {
        this.contractTreeVisible.set(true);
    }

    public boolean getContractTreeVisible() {
        return this.contractTreeVisible.get();
    }

    public SimpleBooleanProperty contractTreeVisibleProperty() {
        return this.contractTreeVisible;
    }

    public ContractTree getContractTree() {
        return this.contractTree;
    }
}

