/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.AbstractOverrideConfigurationsExecutorImpl;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideExcelConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideExcelConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.exception.ApplyingOverridesException;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.DefaultExcelHeadersStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.DefaultExcelOverviewStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.DefaultExcelRowsStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.DefaultExcelStrategiesSetup;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelHeadersStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelOverviewStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelRowsStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelStrategiesSetup;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class OverrideExcelConfigrationsExecutorImpl
extends AbstractOverrideConfigurationsExecutorImpl
implements OverrideExcelConfigurationsExecutor {
    protected static final String HEADERS_STRATEGY = "headersStrategy";
    protected static final String OVERVIEW_STRATEGY = "overviewStrategy";
    protected static final String ROWS_STRATEGY = "rowsStrategy";
    protected final ApplicationContext ctx;

    @Inject
    public OverrideExcelConfigrationsExecutorImpl(ApplicationContext ctx) {
        super(ctx.getService(EventBus.class), ctx.getService(ApplicationConfigurationService.class));
        this.ctx = ctx;
    }

    @Override
    public ExcelStrategiesSetup getExcelSetup(Object target) {
        Object[] configs = (OverrideExcelConfiguration[])target.getClass().getAnnotationsByType(OverrideExcelConfiguration.class);
        if (ArrayUtils.isEmpty(configs)) {
            return this.getDefault(null);
        }
        if (configs.length > 1) {
            throw new ApplyingOverridesException("More than one excel override configuration applied.");
        }
        return this.getExcelSetup((OverrideExcelConfiguration)configs[0]);
    }

    protected ExcelStrategiesSetup getExcelSetup(OverrideExcelConfiguration config) {
        if (StringUtils.isBlank(config.overrideId()) || this.overrides.get(config.overrideId()) == null) {
            return this.getDefault(config);
        }
        String overrideId = config.overrideId();
        JSONObject excelJSONConfiguration = (JSONObject)((JSONArray)this.overrides.get(overrideId)).get(0);
        String headersStrategy = (String)excelJSONConfiguration.get(HEADERS_STRATEGY);
        String overviewStrategy = (String)excelJSONConfiguration.get(OVERVIEW_STRATEGY);
        String rowsStrategy = (String)excelJSONConfiguration.get(ROWS_STRATEGY);
        try {
            ExcelHeadersStrategy<Orderbook> headersStrategyImpl = this.getExcelHeadersStrategy(headersStrategy);
            ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> rowsStrategyImpl = this.getExcelRowsStrategy(rowsStrategy);
            ExcelOverviewStrategy<Orderbook> overviewStrategyImpl = this.getExcelOverviewStrategy(overviewStrategy);
            return new ExcelStrategiesSetup(overviewStrategyImpl, rowsStrategyImpl, headersStrategyImpl);
        }
        catch (Exception e) {
            throw new ApplyingOverridesException("Error during initializing strategies. ", e);
        }
    }

    private ExcelOverviewStrategy<Orderbook> getExcelOverviewStrategy(String overviewStrategy) throws ReflectiveOperationException {
        return StringUtils.isNotBlank(overviewStrategy) ? (ExcelOverviewStrategy)Class.forName(overviewStrategy).getConstructor(ApplicationContext.class).newInstance(this.ctx) : new DefaultExcelOverviewStrategy(this.ctx);
    }

    private ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> getExcelRowsStrategy(String rowsStrategy) throws ReflectiveOperationException {
        return StringUtils.isNotBlank(rowsStrategy) ? (ExcelRowsStrategy)Class.forName(rowsStrategy).getConstructor(ApplicationContext.class).newInstance(this.ctx) : new DefaultExcelRowsStrategy(this.ctx);
    }

    private ExcelHeadersStrategy<Orderbook> getExcelHeadersStrategy(String headersStrategy) throws ReflectiveOperationException {
        return StringUtils.isNotBlank(headersStrategy) ? (ExcelHeadersStrategy)Class.forName(headersStrategy).newInstance() : new DefaultExcelHeadersStrategy();
    }

    private ExcelStrategiesSetup getDefault(OverrideExcelConfiguration config) {
        try {
            ExcelStrategiesSetup setup = DefaultExcelStrategiesSetup.create(this.ctx);
            if (config != null) {
                if (StringUtils.isNotBlank(config.defaultOverviewStrategy())) {
                    setup.setOverviewStrategy(this.getExcelOverviewStrategy(config.defaultOverviewStrategy()));
                }
                if (StringUtils.isNotBlank(config.defaultHeadersStrategy())) {
                    setup.setHeadersStrategy(this.getExcelHeadersStrategy(config.defaultHeadersStrategy()));
                }
                if (StringUtils.isNotBlank(config.defaultRowsStrategy())) {
                    setup.setRowsStrategy(this.getExcelRowsStrategy(config.defaultRowsStrategy()));
                }
            }
            return setup;
        }
        catch (Exception e) {
            throw new ApplyingOverridesException("Error during initializing strategies. ", e);
        }
    }
}

