/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelInClipBoard;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

@Singleton
public class GuiStateService {
    private final BooleanProperty editMode = new SimpleBooleanProperty(false);
    private boolean suspendEditMode = false;
    private final ObjectProperty<PanelInClipBoard> panelInClipBoard = new SimpleObjectProperty<PanelInClipBoard>();

    @Inject
    public GuiStateService(EventBus eventBus) {
        this.editMode.addListener((observableValue, oldValue, newValue) -> eventBus.post(new EditEvent((boolean)newValue)));
    }

    public void startEditMode() {
        if (!this.suspendEditMode) {
            this.editMode.setValue(true);
        }
    }

    public void stopEditMode() {
        if (!this.suspendEditMode) {
            this.editMode.setValue(false);
        }
    }

    public void toggleEditMode() {
        if (!this.suspendEditMode) {
            this.editMode.setValue(this.editMode.getValue() == false);
        }
    }

    public boolean isEditMode() {
        return this.editMode.get();
    }

    public ReadOnlyBooleanProperty editModeProperty() {
        return this.editMode;
    }

    public boolean isSuspendEditMode() {
        return this.suspendEditMode;
    }

    public void setSuspendEditMode(boolean suspendEditMode) {
        this.suspendEditMode = suspendEditMode;
    }

    public PanelInClipBoard getPanelInClipBoard() {
        return (PanelInClipBoard)this.panelInClipBoard.get();
    }

    public ObjectProperty<PanelInClipBoard> panelInClipBoardProperty() {
        return this.panelInClipBoard;
    }

    public void setPanelInClipBoard(PanelInClipBoard panelInClipBoard) {
        this.panelInClipBoard.set(panelInClipBoard);
    }
}

