/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.ModalStages;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFXUserAlertService
implements UserAlertService {
    private static final Logger LOG = LoggerFactory.getLogger(JFXUserAlertService.class);
    @Inject
    private ApplicationContext appContext;

    @Override
    public void showConfirmationDialog(String titleLabel, String messageLabel, String expandedText, UserAlertService.Flag ... flags) {
        FxUtil.runInFxThread(() -> {
            Alert alert = new Alert(this.mapSeverity(flags), "", this.getConfirmationButtonTypes(flags));
            this.decorateButtons(alert.getDialogPane());
            this.fillDialog(titleLabel, messageLabel, expandedText, false, alert, flags);
            if (this.hasFlag(flags, UserAlertService.Flag.NON_BLOCKING)) {
                alert.show();
            } else {
                ModalStages.makeModal((Stage)alert.getDialogPane().getScene().getWindow());
                alert.showAndWait();
            }
        });
    }

    @Override
    public boolean showQuestionDialog(String titleLabel, String messageLabel, String expandedText, boolean expandDialog, UserAlertService.Flag ... flags) {
        SettableFuture answer = SettableFuture.create();
        FxUtil.runInFxThread(() -> {
            Optional result;
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "", this.getQuestionButtonTypes(flags));
            this.decorateButtons(alert.getDialogPane());
            this.fillDialog(titleLabel, messageLabel, expandedText, expandDialog, alert, flags);
            if (!this.hasFlag(flags, UserAlertService.Flag.NON_BLOCKING)) {
                ModalStages.makeModal((Stage)alert.getDialogPane().getScene().getWindow());
            }
            if ((result = alert.showAndWait()).isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.YES) {
                LOG.info("User pressed YES ({}).", (Object)titleLabel);
                answer.set(true);
            } else if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.NO) {
                answer.set(false);
            } else {
                throw new IllegalStateException("buttonType not found");
            }
        });
        try {
            return (Boolean)answer.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted", e);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @Override
    public void showConfirmationDialog(String titleLabel, String messageLabel, UserAlertService.Flag ... flags) {
        this.showConfirmationDialog(titleLabel, messageLabel, (String)null, flags);
    }

    @Override
    public boolean showQuestionDialog(String titleLabel, String messageLabel, UserAlertService.Flag ... flags) {
        return this.showQuestionDialog(titleLabel, messageLabel, null, false, flags);
    }

    private boolean hasFlag(UserAlertService.Flag[] flags, UserAlertService.Flag flag) {
        return Sets.newHashSet(flags).contains((Object)flag);
    }

    private ButtonType[] getConfirmationButtonTypes(UserAlertService.Flag ... flags) {
        if (this.hasFlag(flags, UserAlertService.Flag.OK)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_ok"), ButtonBar.ButtonData.OK_DONE)};
        }
        if (this.hasFlag(flags, UserAlertService.Flag.CLOSE)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_close"), ButtonBar.ButtonData.CANCEL_CLOSE)};
        }
        return new ButtonType[]{new ButtonType(Util.getLabel("commons_ok"), ButtonBar.ButtonData.OK_DONE)};
    }

    private ButtonType[] getQuestionButtonTypes(UserAlertService.Flag ... flags) {
        if (this.hasFlag(flags, UserAlertService.Flag.OK_CANCEL)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_ok"), ButtonBar.ButtonData.YES), new ButtonType(Util.getLabel("commons_cancel"), ButtonBar.ButtonData.NO)};
        }
        if (this.hasFlag(flags, UserAlertService.Flag.YES_NO)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_yes"), ButtonBar.ButtonData.YES), new ButtonType(Util.getLabel("commons_no"), ButtonBar.ButtonData.NO)};
        }
        if (this.hasFlag(flags, UserAlertService.Flag.RELOGIN_CLOSE)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_relogin"), ButtonBar.ButtonData.YES), new ButtonType(Util.getLabel("commons_close"), ButtonBar.ButtonData.NO)};
        }
        if (this.hasFlag(flags, UserAlertService.Flag.OK_ADD_TO_BASKED)) {
            return new ButtonType[]{new ButtonType(Util.getLabel("commons_ok"), ButtonBar.ButtonData.YES), new ButtonType(Util.getLabel("basket_add_to_basket"), ButtonBar.ButtonData.NO)};
        }
        return new ButtonType[]{new ButtonType(Util.getLabel("commons_yes"), ButtonBar.ButtonData.YES), new ButtonType(Util.getLabel("commons_no"), ButtonBar.ButtonData.NO)};
    }

    private Alert.AlertType mapSeverity(UserAlertService.Flag ... flags) {
        if (this.hasFlag(flags, UserAlertService.Flag.INFO)) {
            return Alert.AlertType.INFORMATION;
        }
        if (this.hasFlag(flags, UserAlertService.Flag.WARNING)) {
            return Alert.AlertType.WARNING;
        }
        if (this.hasFlag(flags, UserAlertService.Flag.ERROR)) {
            return Alert.AlertType.ERROR;
        }
        return Alert.AlertType.INFORMATION;
    }

    private void fillDialog(String titleLabel, String messageLabel, String expandedText, boolean expandDialog, Alert alert, UserAlertService.Flag ... flags) {
        LOG.info("Displaying message {}: {}", (Object)titleLabel, (Object)messageLabel);
        alert.setTitle(titleLabel);
        alert.setHeaderText(null);
        alert.setContentText(messageLabel);
        AlertLabel content = new AlertLabel(messageLabel);
        StyleUtil.addStyleClass(content, "content");
        content.setPrefWidth(360.0);
        content.setWrapText(true);
        alert.getDialogPane().setContent(content);
        alert.getDialogPane().getScene().getWindow().setOnShown(event -> {
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.setPrefHeight(dialogPane.getHeight() + content.getMissingHeight());
        });
        StyleUtil.addStyleClass(alert.getDialogPane(), "jfxDialog");
        if (this.hasFlag(flags, UserAlertService.Flag.HIGH_VISIBILITY)) {
            StyleUtil.addStyleClass(alert.getDialogPane(), "highVisibility");
        }
        this.appContext.getService(StyleService.class).registerSceneForStyleSwitching(alert.getDialogPane().getScene());
        switch (alert.getAlertType()) {
            case CONFIRMATION: {
                alert.setGraphic(new IconView("icon-question-32"));
                break;
            }
            case INFORMATION: {
                alert.setGraphic(new IconView("icon-info-32"));
                break;
            }
            case WARNING: {
                alert.setGraphic(new IconView("icon-sign-warning-32"));
                break;
            }
            case ERROR: {
                alert.setGraphic(new IconView("icon-error-32"));
                break;
            }
        }
        if (StringUtils.isNotEmpty(expandedText)) {
            TextArea textArea = new TextArea(expandedText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            alert.getDialogPane().expandedProperty().addListener((observable2, oldValue, newValue) -> FxUtil.runLater(() -> {
                Window window = alert.getDialogPane().getScene().getWindow();
                window.setHeight(newValue != false ? window.getHeight() + 300.0 : window.getHeight() - 300.0);
            }));
            alert.getDialogPane().setExpandableContent(textArea);
            alert.getDialogPane().setExpanded(expandDialog);
        }
    }

    private void decorateButtons(DialogPane dialogPane) {
        for (ButtonType buttonType : dialogPane.getButtonTypes()) {
            Node button = dialogPane.lookupButton(buttonType);
            if (!(button instanceof Labeled)) continue;
            this.decorateButton((Labeled)button, buttonType);
        }
    }

    private void decorateButton(Labeled button, ButtonType buttonType) {
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        String text = buttonType.getText();
        if (buttonData == ButtonBar.ButtonData.YES && text.equals(Util.getLabel("commons_relogin"))) {
            button.setGraphic(new IconView("button-fill-up"));
        } else if (buttonData == ButtonBar.ButtonData.NO && text.equals(Util.getLabel("basket_add_to_basket"))) {
            button.setGraphic(new IconView("button-add-to-basket"));
        } else if (buttonData == ButtonBar.ButtonData.YES || buttonData == ButtonBar.ButtonData.OK_DONE) {
            button.setGraphic(new IconView("button-ok"));
        } else if (buttonData == ButtonBar.ButtonData.NO || buttonData == ButtonBar.ButtonData.CANCEL_CLOSE) {
            button.setGraphic(new IconView("button-close"));
        }
    }

    private static class AlertLabel
    extends Label {
        public AlertLabel(String text) {
            super(text);
        }

        public double getMissingHeight() {
            return this.computePrefHeight(this.getWidth()) - this.getHeight();
        }
    }
}

