/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.profile.UserProfile;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.FutureExecutor;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MasterProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProfileService.class);
    private final ProfileManager profileManager;
    private final MainPanelService mainPanelService;
    private final UserAlertService userAlertService;
    private final SettingsService settingsService;
    private final FutureExecutor profileLoadingExecutor;
    private final ExecutorService executorService;
    private final MessagePublisher messagePublisher;

    @Inject
    public MasterProfileService(ApplicationContext appContext) {
        this.profileManager = appContext.getService(ProfileManager.class);
        this.mainPanelService = appContext.getService(MainPanelService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.executorService = appContext.getService(ExecutorService.class, WorkerExecutor.class);
        this.profileLoadingExecutor = new FutureExecutor(this.executorService);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
    }

    public void loadSavedProfile(boolean showQuestionDialog) {
        if (!showQuestionDialog || this.userAlertService.showQuestionDialog(Util.getLabel("comXervClient_restoreLastSavedComponents_popup_question_title"), Util.getLabel("comXervClient_restoreLastSavedComponents_popup_question"), new UserAlertService.Flag[0])) {
            Platform.setImplicitExit(false);
            this.mainPanelService.closeAllMainPanels();
            Future<UserProfile> profileFuture = this.profileManager.loadProfile();
            this.profileLoadingExecutor.waitForFutureToComplete(profileFuture, userProfile -> this.applyLoadedProfile(), this::masterProfileLoadFailed);
        }
    }

    private void applyLoadedProfile() {
        this.mainPanelService.loadSavedMainPanels();
        this.mainPanelService.showMainPanels();
        this.settingsService.loadAllSettings();
        Platform.setImplicitExit(true);
        this.mainPanelService.resetMainPanelMinSize();
    }

    private void masterProfileLoadFailed(Exception exception) {
        LOG.error("Could not load master profile.", exception);
    }

    public void loadDefaultProfile(boolean showQuestionDialogAndRestoreInMemoryPanels) {
        if (!showQuestionDialogAndRestoreInMemoryPanels || this.userAlertService.showQuestionDialog(Util.getLabel("comXervClient_restoreDefaultComponents_popup_question_title"), Util.getLabel("comXervClient_restoreDefaultComponents_popup_question"), new UserAlertService.Flag[0])) {
            Platform.setImplicitExit(false);
            this.mainPanelService.closeAllMainPanels();
            Future<UserProfile> defaultProfileLoaded = this.profileManager.loadDefaultProfile();
            this.profileLoadingExecutor.waitForFutureToComplete(defaultProfileLoaded, userProfile -> this.applyLoadedProfile(), this::masterProfileLoadFailed);
        }
    }

    public void importAndLoadProfile(File file) {
        if (file != null) {
            this.executorService.execute(() -> {
                Platform.setImplicitExit(false);
                this.mainPanelService.closeAllMainPanels();
                Future<UserProfile> profileLoaded = this.profileManager.importProfile(file);
                this.profileLoadingExecutor.waitForFutureToComplete(profileLoaded, this::profileImported, this::profileImportFailed);
            });
        }
    }

    private void profileImported(UserProfile userProfile) {
        this.applyLoadedProfile();
        this.messagePublisher.publishMessage(Util.getLabel("feedback_profile_imported"), MessageSeverity.LOW);
    }

    private void profileImportFailed(Exception exception) {
        LOG.error("Profile import failed", exception);
        this.applyLoadedProfile();
        this.messagePublisher.publishMessage(Util.getLabel("feedback_profile_import_failed"), MessageSeverity.LOW);
    }

    public void saveConfiguration() {
        CountDownLatch allMainPanelsReady = this.mainPanelService.prepareAllMainPanelsForSaveConfiguration();
        Future<Void> saveProfileFuture = this.executorService.submit(() -> {
            boolean countedDown = allMainPanelsReady.await(10L, TimeUnit.SECONDS);
            if (!countedDown) {
                LOG.error("allMainPanelsReady await elapsed before the count reached zero");
            }
            this.profileManager.saveProfile();
            return null;
        });
        this.profileLoadingExecutor.waitForFutureToComplete(saveProfileFuture, this::saveConfigurationSucceeded, this::saveConfigurationFailed);
    }

    private void saveConfigurationSucceeded(Void nothing) {
        this.messagePublisher.publishMessage(Util.getLabel("feedback_configuration_saved"), MessageSeverity.LOW);
    }

    private void saveConfigurationFailed(Exception exception) {
        String text = Util.getLabel("feedback_configuration_save_failed") + " " + exception.getMessage();
        LOG.error(text, exception);
        this.messagePublisher.publishMessage(text, MessageSeverity.LOW);
    }
}

