/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.google.common.base.Charsets;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;

@Singleton
public class MessageSender {
    private final ExecutorService executorService;
    private final BackendConnectionGateway backendConnectionGateway;

    @Inject
    public MessageSender(ApplicationContext applicationContext) {
        this.executorService = applicationContext.getService(ExecutorService.class, SenderExecutor.class);
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
    }

    public void send(String routingKey, String xml, boolean compress, Long userInputtedEventIndex) {
        byte[] messageBytes = xml.getBytes(Charsets.UTF_8);
        this.executorService.execute(() -> this.backendConnectionGateway.getConnection().sendRequest(messageBytes, routingKey, 10000, true, true, compress, userInputtedEventIndex));
    }

    @Subscribe
    public void handleApplicationShutdown(ApplicationShutdownEvent event) {
        this.executorService.shutdown();
    }
}

