/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.entities.session.ProxyType;
import com.deutscheboerse.comxerv.comtrader.service.event.LoginEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.prefs.Preferences;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ProxySettings {
    private static final String PROXY_TYPE = "ProxyType";
    private static final String PROXY_HOSTNAME = "ProxyHostname";
    private static final String PROXY_PORT = "ProxyPort";
    private static final String PROXY_USR = "ProxyUsername";
    private static final String PROXY_PWD = "ProxyPassword";
    private ObjectProperty<ProxyType> proxyType = new SimpleObjectProperty<ProxyType>(ProxyType.NO_PROXY);
    private StringProperty proxyHostname = new SimpleStringProperty("");
    private StringProperty proxyPort = new SimpleStringProperty("");
    private StringProperty proxyUsername = new SimpleStringProperty("");
    private StringProperty proxyPassword = new SimpleStringProperty("");
    private final Preferences preferences = Preferences.userNodeForPackage(ProxySettings.class);

    @Inject
    public ProxySettings(EventBus eventBus) {
        this.loadSettings();
        eventBus.register(this);
    }

    @Subscribe
    public void handleLogin(LoginEvent event) {
        this.saveSettings();
    }

    public void loadSettings() {
        try {
            this.setProxyType(ProxyType.valueOf(this.preferences.get(PROXY_TYPE, ProxyType.NO_PROXY.name())));
        }
        catch (IllegalArgumentException e) {
            this.setProxyType(ProxyType.NO_PROXY);
        }
        this.setProxyHostname(this.preferences.get(PROXY_HOSTNAME, ""));
        this.setProxyPort(this.preferences.get(PROXY_PORT, ""));
        this.setProxyPassword(this.preferences.get(PROXY_PWD, ""));
        this.setProxyUsername(this.preferences.get(PROXY_USR, ""));
    }

    public void saveSettings() {
        this.preferences.put(PROXY_TYPE, this.getProxyType().name());
        this.preferences.put(PROXY_HOSTNAME, this.getProxyHostname());
        this.preferences.put(PROXY_PORT, this.getProxyPort());
        this.preferences.put(PROXY_USR, this.getProxyUsername());
        this.preferences.put(PROXY_PWD, this.getProxyPassword());
    }

    public ObjectProperty<ProxyType> proxyTypeProperty() {
        return this.proxyType;
    }

    public ProxyType getProxyType() {
        return (ProxyType)this.proxyType.get();
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType.set(proxyType);
    }

    public String getProxyHostname() {
        return (String)this.proxyHostname.get();
    }

    public StringProperty proxyHostnameProperty() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname.set(proxyHostname);
    }

    public String getProxyPort() {
        return (String)this.proxyPort.get();
    }

    public StringProperty proxyPortProperty() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort.set(proxyPort);
    }

    public String getProxyUsername() {
        return (String)this.proxyUsername.get();
    }

    public StringProperty proxyUsernameProperty() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername.set(proxyUsername);
    }

    public String getProxyPassword() {
        return (String)this.proxyPassword.get();
    }

    public StringProperty proxyPasswordProperty() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword.set(proxyPassword);
    }

    public boolean isProxyDefined() {
        return this.getProxyType().isProxy();
    }

    public boolean isProxySecured() {
        return this.isProxyDefined() && StringUtils.isNotEmpty(this.getProxyUsername()) && StringUtils.isNotEmpty(this.getProxyPassword());
    }

    public int getProxyPortNumber() {
        return StringUtils.isNotEmpty(this.getProxyPort()) ? Integer.parseInt(this.getProxyPort()) : 0;
    }
}

